<?php

//Tour tags custom widget

class Turio_Tour_Tags extends WP_Widget {

    function __construct() {
        parent::__construct(

// Base ID of our widget
            'turio_tour_tags',

// Widget name
            __( 'Turio Tour Tags', 'turio-core' ),

// Widget description
            array( 'description' => __( 'Turio Tour Tags', 'turio-core' ), )
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        ?>

        <aside class="blog-widget mt-30 widget-tag-cloud">
            <div class="widget-title">
                <?php if( !empty( $title ) ): ?>
                    <h4><?php echo  esc_attr( __( $title, 'turio-core' ) ); ?></h4>
                <?php endif; ?>
            </div>
            <div class="tag-cloud widget-body">
            <?php 
                $arg = array(
                    'taxonomy' => 'turio-package-tags',
                    'hide_empty' => false,
                    'orderby' => 'count',
                    'order'   => 'DESC',
                );
                $tags = get_tags( $arg );
                $count = 0;
                foreach ( $tags as $tag ) {
                    $count++;
                    $tag_link = get_tag_link( $tag->term_id ); 
                    ?> 
                <a href="<?php echo esc_url( $tag_link ); ?>"><?php echo $tag->name; ?></a>
                <?php if( $count > 20 ) break; ?>
                       <?php
                    }
        
                ?>
            </div>
        </aside>
        <?php
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        ?>
        <!--Title-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance){
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}
if (!function_exists('Turio_Tour_Tags')) {
    function Turio_Tour_Tags()
    {
        register_widget('Turio_Tour_Tags');
    }
    add_action('widgets_init', 'Turio_Tour_Tags');
}
