<?php

class Turio_Sidebar_Banner_Widget extends WP_Widget
{

    /**
     * Register widget with WordPress.
     */
    public function __construct()
    {
        parent::__construct(

            'turio_sidebar_banner', // Base ID

            __('Turio Sidebar Banner', 'turio-core'), // Name

            array('description' => __('Turio Sidebar Banner', 'turio-core'),) // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget($args, $instance)
    {

        $display_image = false;
        if ($instance['image']) {
            $display_image = 1;

            $image_src = wp_get_attachment_image_src($instance['image'], "thumbnail");
        }

?>
        <div class="sidebar-banner p-sidebar-banner mt-40">
            
             <?php if ($display_image) { ?>
                <img src="<?php echo esc_url($image_src[0]); ?>" alt="<?php _e('sidebar-banner', 'turio-core'); ?>" class="img-fluid">
            <?php } ?>  
                <div class="sidebar-banner-overlay">
                    <div class="sidebar-content">
                    <?php
                        if ( isset( $instance['title'] ) ) {
                            echo wp_kses_post($args['before_title']);
                        ?> <h3> <?php echo $instance['title']; ?> </h3> <?php
                            echo wp_kses_post($args['after_title']);
                        }
                    ?>
                        <?php if( ! empty( $instance['button_text'] ) ){ ?>
                            <div class="sidebar-banner-btn">
                                <a href="<?php echo  esc_url( __( $instance['url'], 'turio-core' ) ); ?>"><?php echo  esc_attr( __( $instance['button_text'], 'turio-core' ) ); ?></a>
                            </div>
                        <?php } ; ?>
                    </div>
                </div>
        </div>
    <?php
    }

    /**
     * Back-end widget form.
     *
     * @see WP_Widget::form()
     *
     * @param array $instance Previously saved values from database.
     */
    public function form($instance)
    {

        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }

        $button_text = '';
        if (isset($instance['button_text'])) {
            $button_text = $instance['button_text'];
        }

        if (!isset($instance['url'])) {
            $instance['url'] = "";
        }

        if (!isset($instance['image'])) {
            $instance['image'] = "";
        }

    ?>

        <!-- banner tittle -->
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>" />
        </p>

        <!-- image uploader -->
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('image')); ?>"><?php _e('Image:', 'turio-core'); ?></label>
            <br />
        <p class="imgpreview"></p>
        <input class="imgph" type="hidden" id="<?php echo esc_attr($this->get_field_id('image')); ?>" name="<?php echo esc_attr($this->get_field_name('image')); ?>" value="<?php echo esc_attr($instance['image']); ?>" />
        <input type="button" class="button btn-primary widgetuploader" value="<?php _e('Add Image', 'turio-core'); ?>" />
        </p>

        <!-- button text -->
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('button_text')); ?>"><?php _e('button Text:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('button_text')); ?>" name="<?php echo esc_attr($this->get_field_name('button_text')); ?>" type="text" value="<?php echo esc_attr($button_text); ?>" />
        </p>

        <!-- button url -->
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('url')); ?>"><?php _e('Target URL:', 'turio-core'); ?></label>
            <br />
            <input class="widefat" type="url" id="<?php echo esc_attr($this->get_field_id('url')); ?>" name="<?php echo esc_attr($this->get_field_name('url')); ?>" value="<?php echo esc_attr($instance['url']); ?>" />
        </p>
<?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @see WP_Widget::update()
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     *
     * @return array Updated safe values to be saved.
     */
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['image'] = sanitize_text_field($new_instance['image']);
        $instance['button_text'] = sanitize_text_field($new_instance['button_text']);
        $instance['url'] = sanitize_text_field($new_instance['url']);

        return $instance;
    }
}
if (!function_exists('Turio_Sidebar_Banner_Widget')) {
    function Turio_Sidebar_Banner_Widget()
    {
        register_widget('Turio_Sidebar_Banner_Widget');
    }
    add_action('widgets_init', 'Turio_Sidebar_Banner_Widget');
}
