<?php

//recent post custom widget

class Turio_Category_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(

// Base ID of our widget
            'turio_category_widget',

// Widget name
            __( 'Turio Category', 'turio-core' ),

// Widget description
            array( 'description' => __( 'Turio Category  Widget', 'turio-core' ), )
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        ?>
    <!-- turio Category start -->
    <aside class="blog-widget widget-categories mt-30">
        <div class="widget-title">
        <?php if( !empty( $title ) ): ?>
            <h4><?php echo  esc_attr( __( $title, 'category' ) ); ?></h4>
            <?php endif; ?>
        </div>
        <ul class="widget-body">
            <?php 
                $args = array(
                'orderby'            => 'name',
                'order'              => 'ASC',
                'show_count'         => 0,
                );
                $categories = get_categories( $args );
                 
                foreach ( $categories as $category ) {
                    ?>
                     <li>
                         <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><h6><i class="bi bi-chevron-double-right"></i> <?php echo esc_html( $category->name ); ?></h6> <span>(<?php echo $category->category_count; ?>)</span></a>
                    </li>
                    <?php   
                    
                }
                ?>
        </ul>
    </aside>
    <!-- turio Category end -->
        <?php
    }

    // Widget Backend
    public function form($instance)
    {
        $title = '';
        if (isset($instance['title'])) {
            $title = $instance['title'];
        }
        ?>
        <!--Title-->
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'turio-core'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                   name="<?php echo $this->get_field_name('title'); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>"/>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance){
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}
if ( ! function_exists('Turio_Category_Widget') ){
	function Turio_Category_Widget(){
		register_widget('Turio_Category_Widget');
	}
	add_action('widgets_init','Turio_Category_Widget');
}
