<?php
/**
 * @package Turio
 * @author Egens Lab
 */
if (!defined("ABSPATH")) {
    exit(); //exit if access directly
}

if (!class_exists('TurioCoreInit')) {

    class TurioCoreInit
    {
        /*
        * $instance
        * @since 1.0.0
        * */
        protected static $instance;

        public function __construct()
        {
        	//Load plugin assets
	        add_action('wp_enqueue_scripts',array($this,'plugin_assets'));
        	//Load plugin admin assets
	        add_action('admin_enqueue_scripts',array($this,'admin_assets'));
        	//load plugin text domain
	        add_action('init',array($this,'load_textdomain'));
	        //load plugin dependency files()
            add_action('plugins_loaded',[$this, 'load_plugin_dependency_files']);
        }

        /**
         * getInstance()
         * */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }
            return self::$instance;
        }

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 * */
		public function load_textdomain(){
			load_plugin_textdomain('turio-core',false,TURIO_CORE_ROOT_PATH .'/languages');
		}

		/**
		 * load plugin dependency files()
		 * @since 1.0.0
		 * */
		public function load_plugin_dependency_files(){
			$includes_files = array(
				// Codestar Framework
				array(
					'file-name' => 'codestar-framework',
					'folder-name' => TURIO_CORE_LIB .'/codestar-framework'
				),
				
				// Custom Post Type
				array(
					'file-name' => 'class-custom-post-type',
					'folder-name' => TURIO_CORE_ADMIN
				),

				//Elementor
				array(
					'file-name' => 'class-elementor-widget-init',
					'folder-name' => TURIO_CORE_ELEMENTOR
				),

				// Popular Package Widget 
				array(
					'file-name' => 'class-popular-tour-package-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Social Link widget
				array(
					'file-name' => 'class-social-link-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Contact Details widget 
				array(
					'file-name' => 'class-contact-details-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Category widget
				array(
					'file-name' => 'class-category-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Popular Post widget
				array(
					'file-name' => 'class-recent-post-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Tour Tags widget
				array(
					'file-name' => 'class-tour-tags-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),

				//Sidebar Banner widget
				array(
					'file-name' => 'class-sidebar-banner-widget',
					'folder-name' => TURIO_CORE_WP_WIDGETS
				),
				//Sidebar Gallery widget
				// array(
				// 	'file-name' => 'class-gallery-widget',
				// 	'folder-name' => TURIO_CORE_WP_WIDGETS
				// ),

			);
		
			if (is_array($includes_files) && !empty($includes_files)){
				foreach ($includes_files as $file){
					if (file_exists($file['folder-name'].'/'.$file['file-name'].'.php')){
						require_once $file['folder-name'].'/'.$file['file-name'].'.php';
					}
				}
			}
		}

		/**
		 * admin assets
		 * @since 1.0.0
		 * */
		public function plugin_assets(){
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

	    /**
	     * load plugin css files()
	     * @since 1.0.0
	     * */
	    public function load_plugin_css_files(){
		    $plugin_version = TURIO_CORE_ENV ? time() : TURIO_CORE_VERSION;
		    $all_css_files = array(
				array(
				    'handle' => 'boxicons',
				    'src' => TURIO_CORE_CSS .'/boxicons.min.css',
				    'deps' => array(),
				    'ver' => $plugin_version,
				    'media' => 'all'
			    ),
		    );
		    

		    $all_css_files = apply_filters('TURIO_CORE_css',$all_css_files);

		    if (is_array($all_css_files) && !empty($all_css_files)){
			    foreach ($all_css_files as $css){
				    call_user_func_array('wp_enqueue_style',$css);
			    }
		    }

	    }

	    /**
	     * load plugin js files
	     * @since 1.0.0
	     * */
	    public function load_plugin_js_files(){
		    $plugin_version = TURIO_CORE_VERSION;
		    $all_js_files = array(
			    array(
				    'handle' => 'main-custom',
				    'src' => TURIO_CORE_JS .'/main-custom.js',
				    'deps' => array('jquery'),
				    'ver' => $plugin_version,
				    'args' => array('','true')
				),
		    );

			$all_js_files = apply_filters('turio_core_js',$all_js_files);
			
		    if (is_array($all_js_files) && !empty($all_js_files)){
			    foreach ($all_js_files as $js){
				    call_user_func_array('wp_enqueue_script',$js);
			    }
		    }
	    }

		/**
		 * admin assets
		 * @since 1.0.0
		 * */
		public function admin_assets(){
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * load plugin admin css files()
		 * @since 1.0.0
		 * */
		public function load_admin_css_files(){
			$plugin_version = TURIO_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'turio-core-admin-style',
					'src' => TURIO_CORE_ADMIN_ASSETS .'/css/admin-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('turio_core_admin_css',$all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)){
				foreach ($all_css_files as $css){
					call_user_func_array('wp_enqueue_style',$css);
				}
			}
		}

		/**
		 * load plugin admin js
		 * @since 1.0.0
		 * */
		public function load_admin_js_files(){
			$plugin_version = TURIO_CORE_VERSION;
			$all_js_files = array(
				array(
					'handle' => 'turio-core-admin-custom',
					'src' => TURIO_CORE_ADMIN_ASSETS .'/js/admin-custom.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'args' => array('','true')
				),
				array(
				    'handle' => 'media-gallery',
				    'src' => TURIO_CORE_ADMIN_ASSETS .'/js/media-gallery.js',
				    'deps' => array('jquery'),
				    'ver' => $plugin_version,
				    'args' => array('','true')
			    ),

			);

			$all_js_files = apply_filters('turio_admin_js',$all_js_files);
			if (is_array($all_js_files) && !empty($all_js_files)){
				foreach ($all_js_files as $js){
					call_user_func_array('wp_enqueue_script',$js);
				}
			}
		}

    }//end class
    if (class_exists('TurioCoreInit')){
	    TurioCoreInit::getInstance();
    }
}

