<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioWhyWeTwoWidget extends Widget_Base {

	public function get_name() {
		return 'turio_why_we_two';
	}

	public function get_title() {
		return esc_html__( 'TX Why We Two', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// Start Why We Section
        $this->start_controls_section(
			'section_left_content',
			[
				'label' 		=> esc_html__( 'Content Left', 'turio-core' ),
			]
		);
		$this->add_control(
			'section_left_content_enable',
			[
				'label' 		=> esc_html__( 'Show Left Content', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
        $this->add_control(
			'section_left_content_main_title_enable',
			[
				'label' 		=> esc_html__( 'Show Main Title', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'section_left_title',
			[
				'label' 		=> esc_html__( 'Main Title', 'turio-core' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', 'turio-core' ),
				'default' 		=> __( 'Why Package Book With <span>Turio?</span>', 'turio-core' ),
				'label_block'   => true,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'section_item_number',
			[
				'label'   => esc_html__('Number', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Type number here'),
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'section_left_item_title',
			[
				'label'   => esc_html__('Item Title', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Type faq title'),
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'section_left_item_description',
			[
				'label'       => esc_html__('Item Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('Type faq description', 'turio-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_list',
			[
				'label' => esc_html__( 'Who we are items', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'section_left_item_title'          =>'Awesome Tour',
						'section_item_number' 				=> '500+',
						'section_left_item_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt enlane molestie turpis nec lacinia vehicula.'
					],
					[
						'section_left_item_title'          => 'Destinations',
						'section_item_number' 				=> '300+',
						'section_left_item_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt enlane molestie turpis nec lacinia vehicula.'
					],
					[
						'section_left_item_title'          => ' Mountains',
						'section_item_number' 				=> '150+',
						'section_left_item_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt enlane molestie turpis nec lacinia vehicula.'
					],
				],
				'title_field' => '{{section_left_item_title}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'section_right_content',
			[
				'label' 		=> esc_html__( 'Content Right', 'turio-core' ),
			]
		);
        $this->add_control(
			'section_right_content_enable',
			[
				'label' 		=> esc_html__( 'Show Right Content', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
        $this->add_control(
			'section_right_content_image',
			[
				'label' => esc_html__( 'Choose Image', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

        $this->end_controls_section();
        // End Why We Section
		// Start Style Section
		$this->start_controls_section(
			'section_style',
			[
				'label' 	=> esc_html__('Main Title'),
				'tab'		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_main_title_color',
			[
				'label' 		=> esc_html__( 'Main Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2d373c',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .achievement-counter-wrap h2.about-wrap-title'   => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'section_style_inner_title_color',
			[
				'label' 		=> esc_html__( 'Inner Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .achievement-counter-wrap h2.about-wrap-title span'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_inner_title_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .achievement-counter-wrap h2.about-wrap-title'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_list_number',
			[
				'label'		   => esc_html__('Item Number'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_number_color',
			[
				'label' 		=> esc_html__( 'Number Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .achievement-counter-cards h2'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_number_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .achievement-counter-cards h2'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_list_title',
			[
				'label'		   => esc_html__('Item Title'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_title_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .achievement-counter-cards h6'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_title_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .achievement-counter-cards h6'
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_list_description',
			[
				'label'		   => esc_html__('Item Description'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_description_color',
			[
				'label' 		=> esc_html__( 'Description Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#666666',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .achievement-counter-cards p'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_description_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .achievement-counter-cards p'
			]
		);
		$this->end_controls_section();
		// End Style Section
    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    <div class="about-main-wrappper">
        <div class="container">
            <div class="row align-items-center">
                <?php if(!empty($settings['section_left_content_enable']) == 'yes') : ?>
                <div class="<?php if($settings['section_right_content_enable'] == 'yes'){echo 'col-lg-6';}else{echo 'col-lg-12';} ?>">
                    <div class="achievement-counter-wrap">
                        <?php if(!empty($settings['section_left_title']) && $settings['section_left_content_main_title_enable'] == 'yes') : ?>
                            <h2 class="about-wrap-title">
                                <?php echo _e($settings['section_left_title'],'turio-core') ?>
                            </h2>
                        <?php endif ?>
                        <div class="achievement-counter-cards">
                            <?php foreach($settings['section_list'] as $item) : ?>
                                <div class="achievement-counter-card flex-sm-row flex-column text-sm-start text-center ">
                                    <div class="counter-box mb-sm-0 mb-3">
                                        <?php if(!empty($item['section_item_number'])) : ?>
                                            <h2><?php  esc_html_e($item['section_item_number'],'turio-core') ?></h2>
                                        <?php endif ?>
                                        <?php if(!empty($item['section_left_item_title'])) : ?>
                                            <h6><?php esc_html_e($item['section_left_item_title'],'turio-core')?></h6>
                                        <?php endif ?>
                                    </div>
                                    <?php if(!empty($item['section_left_item_description'])) : ?>
                                    <p>
                                        <?php esc_html_e($item['section_left_item_description'],'turio-core') ?>
                                    </p>
                                    <?php endif ?>
                                </div>
                            <?php endforeach ?>
                        </div>
                    </div>
                </div>
                <?php endif ?>
                <?php if($settings['section_right_content_enable'] == 'yes') : ?>
                <div class="<?php if($settings['section_left_content_enable'] == 'yes'){echo 'col-lg-6';}else{echo 'col-lg-12';} ?>">
                    <div class="about-image-group mt-5 mt-lg-0">
                        <?php if(!empty($settings['section_right_content_image'])) : ?>
                            <img class="img-fluid" src="<?php echo esc_url($settings['section_right_content_image']['url']); ?>" alt="<?php if(!empty($settings['section_right_content_image']['alt'])){echo $settings['section_right_content_image']['alt']; }; ?>"> 
                        <?php  endif; ?>
                    </div>
                </div>
                <?php endif ?>
            </div>
        </div>
    </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioWhyWeTwoWidget() );
