<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioWhyWeOneWidget extends Widget_Base {

	public function get_name() {
		return 'turio_why_we_one';
	}

	public function get_title() {
		return esc_html__( 'TX Why We One', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// Start Why We Section
        $this->start_controls_section(
			'section_left_content',
			[
				'label' 		=> esc_html__( 'Content Left', 'turio-core' ),
			]
		);
		$this->add_control(
			'section_left_content_enable',
			[
				'label' 		=> esc_html__( 'Show Left Content', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'section_left_content_thumbnail_image',
			[
				'label' => esc_html__( 'Choose Youtube Thumbnail', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'section_left_content_video_url',
			[
				'label' => esc_html__( 'Youtube Video URL', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'turio-core' ),
				'default' => [
					'url' => 'https://www.youtube.com/watch?v=_sI_Ps7JSEk',
				],
			]
		);
		$this->add_control(
			'section_left_content_image_one',
			[
				'label' => esc_html__( 'Choose Image One', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'section_left_content_image_two',
			[
				'label' => esc_html__( 'Choose Image Two', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_right_content',
			[
				'label' 		=> esc_html__( 'Content Right', 'turio-core' ),
			]
		);
		$this->add_control(
			'section_right_content_enable',
			[
				'label' 		=> esc_html__( 'Show Right Content', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Show', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Hide', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'section_right_title',
			[
				'label' 		=> esc_html__( 'Main Title', 'turio-core' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', 'turio-core' ),
				'default' 		=> esc_html__( 'About Our Company And <span>What We Are</span> Offer.', 'turio-core' ),
				'label_block'   => true,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'section_item_number',
			[
				'label'   => esc_html__('Number', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Type number here'),
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'section_right_item_title',
			[
				'label'   => esc_html__('Item Title', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Type faq title'),
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'section_right_item_description',
			[
				'label'       => esc_html__('Item Description', 'turio-core'),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__('Type faq description', 'turio-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Who we are items', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'section_right_item_title'          =>'Year Experience',
						'section_item_number' 				=> '10',
						'section_right_item_description'    => 'One Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consente consectetur.Duis rutrum nisl urna. Maecenas vel libero faucibus '
					],
					[
						'section_right_item_title'          => 'Tour Guide',
						'section_item_number' 				=> '100+',
						'section_right_item_description'    => 'Two Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consente consectetur.'
					],
					[
						'section_right_item_title'          => 'Travelar Connect',
						'section_item_number' 				=> '500+',
						'section_right_item_description'    => 'Three Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consente consectetur.'
					],
				],
				'title_field' => '{{section_right_item_title}}',
			]
		);
		$this->end_controls_section();
        // End Why We Section
		// Start Style Section
		$this->start_controls_section(
			'section_style',
			[
				'label' 	=> esc_html__('Main Title'),
				'tab'		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_main_title_color',
			[
				'label' 		=> esc_html__( 'Main Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2d373c',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .about-wrap-title'   => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'section_style_inner_title_color',
			[
				'label' 		=> esc_html__( 'Inner Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .about-wrap-title span'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_inner_title_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .about-wrap-title span'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_list_number',
			[
				'label'		   => esc_html__('Item Number'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_number_color',
			[
				'label' 		=> esc_html__( 'Number Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .about-tab-switcher .nav-item h3'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_number_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .about-tab-switcher .nav-item h3'
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_list_title',
			[
				'label'		   => esc_html__('Item Title'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_title_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .about-tab-switcher .nav-item h6'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_title_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .about-tab-switcher .nav-item h6'
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_style_list_description',
			[
				'label'		   => esc_html__('Item Description'),
				'tab'	       => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_style_list_description_color',
			[
				'label' 		=> esc_html__( 'Description Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-main-wrappper .tab-content'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'section_style_list_description_typography',
				'selector' 		=> '{{WRAPPER}} .about-main-wrappper .tab-content'
			]
		);
		$this->end_controls_section();
		// End Style Section
    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    <div class="about-main-wrappper">
        <div class="container">
            <div class="about-tab-wrapper">
                <div class="row justify-content-center align-items-center">
					<?php if(!empty($settings['section_left_content_enable']) == 'yes') : ?>
                    <div class="<?php if(!empty($settings['section_right_content_enable']) == 'yes') echo 'col-lg-6'; else 'col-12';  ?>">
                        <div class="about-tab-image-grid text-center">
                            <div class="about-video d-inline-block">
								<?php if(!empty($settings['section_left_content_thumbnail_image'])) : ?>
	                                <img src="<?php echo esc_url($settings['section_left_content_thumbnail_image']['url']); ?>" alt="<?php if(!empty($settings['section_left_content_thumbnail_image']['alt'])){echo $settings['section_left_content_thumbnail_image']['alt']; }; ?>"> 
                            	<?php  endif; ?>
                                <div class="video-overlay">
									<?php if(!empty($settings['section_left_content_video_url'])) : ?>
										<a data-fancybox href="<?php echo $settings['section_left_content_video_url']['url'] ?>" class="play-icon video-popup">
											<i class="bi bi-play-fill"></i>
										</a>
									<?php endif ?>
                                </div>
                            </div>

                            <div class="row float-images g-4">
                                <div class="col-lg-6 col-md-6 col-sm-6">
									<?php if(!empty($settings['section_left_content_image_one'])) : ?> 
										<div class="about-image">
											<img src="<?php echo $settings['section_left_content_image_one']['url'] ?>" alt="<?php if(!empty($settings['section_left_content_image_one']['alt'])){echo $settings['section_left_content_image_one']['alt']; }; ?>">
										</div>
									<?php endif ?>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6">
									<?php if(!empty($settings['section_left_content_image_two'])) : ?> 
										<div class="about-image">
											<img src="<?php echo $settings['section_left_content_image_two']['url'] ?>" alt="<?php if(!empty($settings['section_left_content_image_two']['alt'])){echo $settings['section_left_content_image_two']['alt']; }; ?>">
										</div>
									<?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php endif ?>
					<?php if(!empty($settings['section_right_content_enable']) == 'yes') : ?>
                    <div class="<?php if(!empty($settings['section_left_content_enable']) == 'yes') echo 'col-lg-6'; else 'col-12';  ?> mt-5 mt-lg-0">
                        <div class="about-tab-wrap">
							<?php if($settings['section_right_title']) : ?>
								<h2 class="about-wrap-title">
									<?php _e($settings['section_right_title']) ?>
								</h2>
							<?php endif ?>
                            <div class="about-tab-switcher">
                                <ul class="nav nav-pills mb-3 justify-content-md-between justify-content-center" id="about-tab-pills" role="tablist">
									<?php $i=0; foreach($settings['list'] as $item ) : $i++;?>
										<li class="nav-item" role="presentation">
											<div class="nav-link <?php if($i == 1){echo 'active';} ?>" id="pills-about<?php echo $i; ?>" data-bs-toggle="pill" data-bs-target="#about-pills<?php echo $i; ?>"  role="tab" aria-controls="about-pills<?php echo $i; ?>" aria-selected="true">
												<h3><?php esc_html_e($item['section_item_number'],'turio-core') ?></h3>
												<h6><?php esc_html_e($item['section_right_item_title'],'turio-core') ?></h6>
											</div>
										</li>
									<?php endforeach ?>
                                </ul>
                            </div>

                            <div class="tab-content about-tab-content" id="pills-tabContent">
								<?php $i = 0; foreach($settings['list'] as $item) : $i++; ?>
									<div class="tab-pane fade show <?php if($i == 1){echo 'active';} ?>" id="about-pills<?php echo $i; ?>" role="tabpanel" aria-labelledby="pills-about<?php echo $i; ?>">
										<?php echo $item['section_right_item_description']; ?>
									</div>
								<?php endforeach ?>
                            </div>
                        </div>
                    </div>
					<?php endif ?>
                </div>
            </div>
        </div>
    </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioWhyWeOneWidget() );
