<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioTestimonialTwoWidget extends Widget_Base {

	public function get_name() {
		return 'turio_testimonial_two';
	}

	public function get_title() {
		return esc_html__( 'TX Testimonial Two', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-testimonial-carousel';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}
	protected function register_controls() {

		// Testimonial Header Section Start
		$this->start_controls_section(
			'turio_testimonial_two_header_setting',
			[
				'label' 		=> esc_html__('Header Settings','turio-core'),
				'tab' 			=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		// Start Header Section Switcher Option
		$this->add_control(
			'turio_testimonial_two_title_switcher',
			[
				'label' 		=> esc_html__( 'Show Title', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_testimonial_two_description_switcher',
			[
				'label' 		=> esc_html__( 'Show Description', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_responsive_control(
			'turio_testimonial_two_heading_alignment',
			[
				'label' 		=> __( 'Alignment', 'turio-core' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => __( 'Left', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => __( 'Center', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => __( 'Right', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => __( 'Justified', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'left',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .heading-section' => 'text-align: {{VALUE}};',
				],
				'conditions' 	=> [
				    'relation' 	=> 'or',
				    'terms' 	=> [
				        ['name' => 'turio_testimonial_two_title_switcher', 'operator' => '===', 'value' => 'yes'],
				        ['name' => 'turio_testimonial_two_description_switcher', 'operator' => '===', 'value' => 'yes'],
				    ],
				],
			]
		);
		$this->add_control(
			'turio_testimonial_two_navigation_switcher',
			[
				'label' 		=> esc_html__( 'Show Navigation (prev/next)', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		$this->add_control(
			'turio_testimonial_two_rating_switcher',
			[
				'label' 		=> esc_html__( 'Show Rating', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value'  => 'yes',
				'default' 		=> 'yes',
			]
		);
		// End Header Section Switcher Option
		$this->add_control(
            'turio_testimonial_two_title',
            [
                'label' 		=> esc_html__( 'Title', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> esc_html__( 'What Our Client Say About Us', 'turio-core' ),
                'label_block' 	=> true,
         
        	]
        );
		$this->add_control(
            'turio_testimonial_two_sub_title',
            [
                'label' 		=> esc_html__( 'Description', 'turio-core' ),
                'type' 			=> Controls_Manager::TEXT,
                'default' 		=> esc_html__( 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt blandit interdum. Sed pellentesque at nunc eget consectetur.', 'turio-core' ),
                'label_block' 	=> true,
            ]
        );
       
		$this->end_controls_section();

		// Testimonial Header Section End
		// Testimonial General Settings
		$this->start_controls_section(
			'turio_testimonial_two_general_setting',
			[
				'label'  		=> esc_html__('General','turio-core'),
				'tab'    		=> Controls_Manager::TAB_CONTENT
			]
		);
		 $this->add_control(
			'turio_testimonial_icon',
			[
				'label' 		=> esc_html__( 'Choose Quote Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::ICONS,
				'default' 		=> [
					'value' 	=> 'bx bxs-quote-left',
					'library' 	=> 'solid',
				],
                'label_block' 	=> true
			]
		);
		$this->end_controls_section();
		// End Testimonial General Settings


		// Testimonial Lists Section Start
		$this->start_controls_section(
			'turio_testimonial_lists',
			[
				'label' 		=> esc_html__( 'Testimonial Lists', 'turio-core' )
			]
		);

        $repeater = new Repeater();
		$repeater->add_control(
			'turio_testimonial_author_image',
			[
				'label'   		=> esc_html__( 'Author Image', 'turio-core' ),
				'type'    		=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'turio_testimonial_background_image',
			[
				'label'   		=> esc_html__( 'Hover Background Image', 'turio-core' ),
				'type'    		=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'turio_testimonial_author_name',
			[
				'label'       	=> esc_html__( 'Name', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXT,
				'default'     	=> esc_html__( 'John Due', 'turio-core' ),
				'label_block' 	=> true,
			]
		);
		$repeater->add_control(
			'turio_testimonial_author_designation',
			[
				'label'       	=> esc_html__( 'Designation', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXT,
				'default'     	=> esc_html__( 'Traveler', 'turio-core' ),
				'label_block' 	=> true,
			]
		);

		// Rating Start

		$repeater->add_control(
			'turio_testimonial_two_rating',
			[
				'label' 		=> esc_html__( 'Rating', 'turio-core' ),
				'type' 			=> Controls_Manager::NUMBER,
				'min' 			=> 0,
				'max' 			=> 5,
				'step' 			=> 1,
				'default' 		=> 5,
				'dynamic' 		=> [
					'active' 	=> true,
				],
			]
		);

		// Rating Start End
        $repeater->add_control(
			'turio_testimonial_author_description',
			[
				'label'       	=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'type'        	=> Controls_Manager::TEXTAREA,
				'label_block' 	=> true,
				'default'     	=> esc_html__( 'but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages', 'turio-core' ),
			]
		);

		$this->add_control(
			'turio_testimonial_list',
			[
				'label' 		=> __( 'Testimonial List', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default'		=> [
					[
						'turio_testimonial_author_name'     => esc_html__( 'Item 1', 'turio-core' ),
						'turio_brand_item_default_active'   => 'yes'
					],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Item 2', 'turio-core' ) ],
					[ 'turio_testimonial_author_name' 		=> esc_html__( 'Item 3', 'turio-core' ) ],
				],
				'title_field'   => '{{turio_testimonial_author_name}}'
			  ,
			]
		);

		$this->end_controls_section();

		// Testimonial Lists Section End

		// Start Testimonial Two Style
		$this->start_controls_section(
			'turio_testimonial_background_style',
			[
				'label'  		=> esc_html__('Background'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		); 
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' 			=> 'background',
				'label' 		=> esc_html__( 'Background', 'turio-core' ),
				'types' 		=> [ 'classic', 'gradient', 'video' ],
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-shape-group',
			]
		);
		$this->end_controls_section();
		//Box Settings Start
		$this->start_controls_section(
			'turio_testimonial_two_box_setting_style',
			[
				'label'  		=> esc_html__('Box Setting'),
				'tab'    		=> Controls_Manager::TAB_STYLE
			]

		);
		$this->add_control(
			'turio_testimonial_two_box_setting_background',
			[
				'label'  		=> esc_html__('Background Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-card-alpha' => 'background : {{VALUE}}',
				]
			]
		);
		 
		$this->add_responsive_control(
			'turio_testimonial_two_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-card-alpha' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		 $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_package_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-card-alpha',
			]
		);
		$this->end_controls_section();

		// Start Testimonial Title Style
		$this->start_controls_section(
			'turio_testimonial_two_title_style',
			[
				'label'   		=> esc_html__('Title','turio-core'),
				'tab'     		=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                'turio_testimonial_two_title_switcher' => 'yes',
            	]   
			]
		);
		$this->add_control(
			'turio_testimonial_two_title_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'default' 		=> '#fff',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .heading-section h2' => 'color: {{VALUE}};',
				],

			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_two_title_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .heading-section h2',

			]
		);
		$this->end_controls_section();
		// End Testimonial Title Style
		// Start Testimonial Description Style
		$this->start_controls_section(
			'turio_testimonial_two_description_style',
			[
				'label'  		=> esc_html__('Description'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' 	=> [
                'turio_testimonial_two_description_switcher' => 'yes',
            	] 
			]
		);
		$this->add_control(
			'turio_testimonial_two_description_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .heading-section p' => 'color : {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_two_description_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .heading-section p',

			]
		);

		$this->end_controls_section();
		// End Testimonial Description Style

		// Start Quote Icon Style
		$this->start_controls_section(
			'turio_testimonial_two_icon_style',
			[
				'label' 		=> esc_html__( 'Quote Icon', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,

			]
		);
        $this->add_control(
			'turio_testimonial_two_icon_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '#F4F5F5',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .qoute-icon i'   => 'color: {{VALUE}};',
          			'{{WRAPPER}} .testimonial-area .qoute-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_two_icon_style_size',
			[
				'label' 		=> esc_html__( 'Width', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px', '%' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 2,
					],
					'%' => [
						'min' 	=> 0,
						'max' 	=> 100,
					],
				],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> 40,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .qoute-icon i'   => 'font-size:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-area .qoute-icon svg' => 'width:  {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .testimonial-area .qoute-icon svg' => 'height:  {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Quote Icon Style
		// Start Testimonial Count Style
		$this->start_controls_section(
			'turio_testimonial_count_style',
			[
				'label'   		=> esc_html__('Testimonial Count','turio-core'),
				'tab'     		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_count_style_color',
			[
				'label'   		=> esc_html__('Color','turio-core'),
				'type'    		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-card-alpha .testimonial-count' => 'color : {{VALUE}}',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    		=> esc_html__('Typography', 'turio-core'),
				'name'     		=> 'turio_testimonial_count_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-card-alpha .testimonial-count',

			]
		);
		$this->end_controls_section();
		// End Testimonial Coutn Style

		// Start Testimonial Icon Style
		$this->start_controls_section(
			'turio_testimonial_icon_style',
			[
				'label'  		=> esc_html__('Navigation (prev/next)','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_testimonial_two_navigation_switcher' => 'yes'
				]
			]
		);
        $this->add_control(
            'turio_testimonial_icon_style_two_color',
            [
                'label'     	=> esc_html__('Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'default'   	=> '#ffb6af',
                'selectors' 	=> [
                    '{{WRAPPER}} .custom-swiper-prev i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .custom-swiper-next i' => 'color: {{VALUE}};',

                ],
            ]
        );
		$this->add_control(
			'turio_testimonial_icon_style_two_border_color',
			[
				'label' => esc_html__( 'Border Color', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .custom-swiper-prev' => 'border:2px solid {{VALUE}}',
					'{{WRAPPER}} .custom-swiper-next' => 'border:2px solid {{VALUE}}',
				],
			]
		);

        $this->add_control(
            'turio_testimonial_icon_style_background_color',
            [
                'label'     	=> esc_html__('Background Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .custom-swiper-prev' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .custom-swiper-next' => 'background: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

		// End Testimonial Icon Style
		// Name Style
		$this->start_controls_section(
			'turio_testimonial_two_author_name_style',
			[
				'label' 		=> esc_html__( 'Name', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_name_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-bottom h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_author_name_style_hover_color',
			[
				'label'     	=> esc_html__( 'Hover Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-bottom h4:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_two_author_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-bottom h4',

			]
		);
		

		$this->end_controls_section();


		// Designation Style
		$this->start_controls_section(
			'turio_testimonial_two_author_designation_style',
			[
				'label' 		=> esc_html__( 'Designation', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_designation_style_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-bottom h6' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_author_designation_style_hover_color',
			[
				'label'     	=> esc_html__( 'Hover Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-bottom h6:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_two_author_designation_style_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-bottom h6',

			]
		);
		
		$this->end_controls_section();


		// Description Style
		$this->start_controls_section(
			'turio_testimonial_author_description_style',
			[
				'label' 		=> esc_html__( 'Testimonial Text', 'turio-core' ),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_testimonial_author_description_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-body p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'turio_testimonial_author_description_hover_color',
			[
				'label'     	=> esc_html__( 'Hover Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-body p:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'label'    		=> esc_html__( 'Typography', 'turio-core' ),
				'name'     		=> 'turio_testimonial_author_description_typography',
				'selector' 		=> '{{WRAPPER}} .testimonial-area .testimonial-body p',

			]
		);

	
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		// Start Rating Control Style
		$this->start_controls_section(
			'turio_testimonial_rating_control_style',
			[
				'label' 		=> esc_html__('Rating','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_testimonial_two_rating_switcher'  	=> 'yes'
				]
			]
		);
		$this->add_control(
			'turio_testimonial_rating_color',
			[
				'label'     	=> esc_html__( 'Color', 'turio-core' ),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-rating li i' => 'color: {{VALUE}};',
				],
			]
		);
 		$this->add_control(
			'turio_testimonial_rating_icon_style_size',
			[
				'label' 		=> esc_html__( 'Size', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SLIDER,
				'size_units' 	=> [ 'px' ],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> 0,
						'max' 	=> 100,
						'step' 	=> 1,
					]
				],
				'default' 		=> [
					'unit' 		=> 'px',
					'size' 		=> 16,
				],
                'selectors' 	=> [
					'{{WRAPPER}} .testimonial-area .testimonial-rating li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// End Rating Control Style

	}
	
	protected function render() {

		$settings = $this->get_settings_for_display(); 

		if (is_admin()) {
			?>
			<script>
		    (function ($) {
				var testimonialSliderOne = new Swiper(".testimonial-slider-two", {
								slidesPerView: 1,
								speed: 1000,
								spaceBetween: 20,
								loop: true,
								roundLengths: true,
								autoplay: {
								delay: 15000,
								},
								navigation: {
								nextEl: ".testi-next",
								prevEl: ".testi-prev",
								},
								breakpoints: {
								480: {
									slidesPerView: 1,
								},
								768: {
									slidesPerView: 1,
								},
								992: {
									slidesPerView: 2,
								},
								1200: {
									slidesPerView: 2,
								},
							},
				});
		    })(jQuery);
			</script>
		<?php
		}
		?>

	<div class="testimonial-area testimonial-style-two">
    	<div class="testimonial-shape-group"></div>
        <div class="container position-relative">
            <div class="row mb-50 align-items-center">
                <div class="<?php if($settings['turio_testimonial_two_navigation_switcher'] == 'yes') { echo "col-lg-8";} else{ echo "col-lg-12"; } ?>">
                    <div class="heading-section">
                    	<?php if (!empty($settings['turio_testimonial_two_title']) && $settings['turio_testimonial_two_title_switcher'] == 'yes'): ?>
                    		<h2><?php  echo $settings['turio_testimonial_two_title'] ?></h2>
                    	<?php endif ?>
                        <?php if (!empty($settings['turio_testimonial_two_sub_title']) && $settings['turio_testimonial_two_description_switcher'] == 'yes'): ?>
                        	<p><?php echo $settings['turio_testimonial_two_sub_title']; ?></p>
                        	
                        <?php endif ?>
                    </div>
                </div>
                <?php if (!empty($settings['turio_testimonial_two_navigation_switcher']) && $settings['turio_testimonial_two_navigation_switcher'] == 'yes'): ?>
                	<div class="col-lg-4">
	                    <div class="slider-arrows text-center d-lg-flex d-none justify-content-end mb-3">
	                        <div class="testi-prev custom-swiper-prev" tabindex="0" role="button" aria-label="Previous slide"> 
	                        	<i class="bi bi-chevron-left"></i> 
	                        </div>
	                        <div class="testi-next custom-swiper-next" tabindex="0" role="button" aria-label="Next slide">
	                        	<i class="bi bi-chevron-right"></i>
	                        </div>
	                    </div>
	                </div>
                <?php endif ?>
            </div>
            <div class="swiper testimonial-slider-two position-relative">
                <div class="swiper-wrapper">
                	<?php 
                		$k = 0;
						if(!empty($settings['turio_testimonial_list'])) :

							foreach ( $settings['turio_testimonial_list'] as $item ) :
							$k++;
						?>
                    <div class="swiper-slide">
                        <div class="testimonial-card testimonial-card-alpha  wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($k+1)*2 ?>00ms">
                            <div class="testimonial-overlay-img">
                                 <?php 
                                    if(!empty($item['turio_testimonial_background_image'])) :
                                        ?>
                                        <img class="img-fluid" src="<?php echo esc_url($item['turio_testimonial_background_image']['url']); ?>" alt="<?php if(!empty($item['turio_testimonial_background_image']['alt'])){echo $item['turio_testimonial_background_image']['alt']; }; ?>">
                                        <?php 
                                    endif;
                                ?>
                            </div>
    
                            <div class="testimonial-card-top">
                            	<?php if (!empty($settings['turio_testimonial_icon'])): ?>
                            		<div class="qoute-icon">
	                                	<?php \Elementor\Icons_Manager::render_icon( $settings['turio_testimonial_icon'], [ 'aria-hidden' => 'true' ] ); ?>
	                                </div>
                            	<?php endif ?>
                                <?php if(!empty($item['turio_testimonial_author_image'])) : ?>
	                                <div class="testimonial-thumb">
	                                     <img class="img-fluid" src="<?php echo esc_url($item['turio_testimonial_author_image']['url']); ?>" alt="<?php if(!empty($item['turio_testimonial_author_image']['alt'])){echo $item['turio_testimonial_author_image']['alt']; }; ?>">       
	                                </div>
                            	<?php  endif; ?>
                            	<?php if (!empty($k)): ?>
                            		<h3 class="testimonial-count">
	                                	<?php echo sprintf("%02d", $k); ?>
	                                </h3>
                            	<?php endif ?>
                            </div>
                            <div class="testimonial-body">
                             <?php if (!empty($item['turio_testimonial_author_description'])): ?>
                             	<p>
                             		<?php echo esc_html__( $item['turio_testimonial_author_description'] ) ?>
                             	</p>
                             <?php endif ?>
                            
                                <div class="testimonial-bottom">
                                    <div class="reviewer-info">
                                    	<?php if (!empty($item['turio_testimonial_author_name'])): ?>
                                    		<h4 class="reviewer-name"><?php echo esc_html__( $item['turio_testimonial_author_name'] ); ?></h4>
                                    		
                                    	<?php endif ?>
                                        <?php if (!empty($item['turio_testimonial_author_designation'])): ?>
                                        	<h6><?php echo esc_html( $item['turio_testimonial_author_designation'] ) ?></h6>
                                        <?php endif ?>
                                    </div>
                                    <?php if (!empty($settings['turio_testimonial_two_rating_switcher']) && $settings['turio_testimonial_two_rating_switcher'] == 'yes'): ?>
                                    	<ul class="testimonial-rating">
											<?php
												for ($i=0; $i <$item['turio_testimonial_two_rating'] ; $i++) {  ?>
												<li><i class="bi bi-star-fill"></i></li>	
											<?php	}
											?>
	                                        
	                                    </ul>
                                    <?php endif ?>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    <?php 
						endforeach;
					endif;
					?>
                </div>
            </div>
        </div>
    </div>
	<?php	}
}

Plugin::instance()->widgets_manager->register( new TurioTestimonialTwoWidget() );
