<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Banner_Slider_Two_Widget extends Widget_Base
{

	public function get_name()
	{
		return 'turio_banner_slider_two';
	}

	public function get_title()
	{
		return esc_html__('Tx Slider Two', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{


		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__('General', 'turio-core')
			]
		);
		$this->add_control(
			'turio_slider_search_switcher',
			[
				'label' => esc_html__('Show Search Bar', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'turio_slider_icon_switcher',
			[
				'label' => esc_html__('Show Location Icon', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_slider_paginate_switcher',
			[
				'label' => esc_html__('Show Pagination', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'slider_sub_title',
			[
				'label'       => esc_html__('Location', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Mount Dtna, Italy', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_title',
			[
				'label'       => esc_html__('Title', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Travel far enough, you meet YOURSELF.', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_price',
			[
				'label'       => esc_html__('Price', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('$250.00 / Per Person', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_description',
			[
				'label'       => esc_html__('Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('Sed convallis sit amet leo quis feugiat. Nunc interdum mollis facilisis. feugi Donec id the urna aliquet, suscipit turpis ut Donec id urna aliquet, suscipit turpis ut, facilisis purus.Sed convallis sit amet leo quis .', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_image',
			[
				'label'   => esc_html__('Choose Image', 'turio-core'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'slider_button_one',
			[
				'label' => esc_html__('Button One', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'slider_button_one_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('View Adventure', 'turio-core'),
			]
		);

		$repeater->add_control(
			'slider_button_one_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);

		$repeater->add_control(
			'slider_button_two',
			[
				'label' => esc_html__('Button Two', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'slider_button_two_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Take A Tour', 'turio-core'),
			]
		);

		$repeater->add_control(
			'slider_button_two_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);

		$this->add_control(
			'turio_slider_list_item',
			[
				'label' => __('Sliders List', 'turio-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'slider_title'          => esc_html__('Item 1', 'turio-core'),
						'slider_title_default_active' => 'yes'
					],
					['slider_title' => esc_html__('Item 2', 'turio-core')],
					['slider_title' => esc_html__('Item 3', 'turio-core')],
				],
				'title_field' => '{{slider_title}}',
			]
		);


		$this->end_controls_section();

		// Background Style
		$this->start_controls_section(
			'slider_sub_title_section',
			[
				'label' => esc_html__('Background', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'turio_slider_background',
				'label' => __('Background', 'turio-core'),
				'types' => ['classic', 'gradient', 'video'],
				'selector' => '{{WRAPPER}} .hero-style-two',
			]
		);
		$this->end_controls_section();

		//Location Style
		$this->start_controls_section(
			'slider_location_section',
			[
				'label' => esc_html__('Location', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'location_icon_color',
			[
				'label'     => esc_html__('Icon Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				// 'default'   => '#54A15D',
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-location i' => 'color: {{VALUE}} ;',
				],
			]
		);
		$this->add_control(
			'slider_location_color',
			[
				'label'     => esc_html__('Text Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2d373c',
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-location' => 'color: {{VALUE}} ;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'slider_location_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-location',

			]
		);
		$this->add_responsive_control(
			'slider_location_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-location' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'slider_location_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-location' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		// Title Style
		$this->start_controls_section(
			'slider_title_section',
			[
				'label' => esc_html__('Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-title' => 'color: {{VALUE}} ;',
				],
			]
		);
		$this->add_control(
			'turio_title_color_two',
			[
				'label'     => esc_html__('Color Two', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-title span' => 'color: {{VALUE}} ;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'slider_title_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-title',

			]
		);
		$this->add_responsive_control(
			'slider_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'slider_title_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Price Style
		$this->start_controls_section(
			'slider_price_style_section',
			[
				'label' => esc_html__('Price', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'slider_price_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2d373c',
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-price' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'slider_price_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-price',

			]
		);
		$this->add_responsive_control(
			'slider_price_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'slider_price_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .featured-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Description Title Style
		$this->start_controls_section(
			'slider_description_section',
			[
				'label' => esc_html__('Description', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'slider_description_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#2d373c',
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'slider_description_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content p',

			]
		);
		$this->add_responsive_control(
			'slider_description_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'slider_description_margin',
			[
				'label' => esc_html__('Margin', 'turio-core'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		//Button Style
		$this->start_controls_section(
			'slider_price_section',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'call_to_action_button_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'call_to_action_button_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_normal_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border_typhography',
				'label' => __('Border', 'turio-core'),
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'call_to_action_button_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a',

			]
		);

		$this->add_responsive_control(
			'call_to_action_button_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'turiocall_to_action_button_hover_typography',
				'selector' => '{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a:hover',

			]
		);

		$this->add_responsive_control(
			'turiocall_to_action_button_hover_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-two .hero-main-wrapper .single-hero-slide .hero-content .hero-btns a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		// Button Style

	}

	protected function render()
	{

		$settings = $this->get_settings_for_display();

		if (is_admin()) {
?>
			<script>
				(function($) {
					//hero slider two
					var heroSliderTwo = new Swiper(".hero-slider-two", {
						slidesPerView: 1,
						speed: 1500,
						spaceBetween: 0,
						loop: true,
						centeredSlides: true,
						roundLengths: true,

						autoplay: {
							delay: 7000,
						},
						pagination: {
							el: ".hero-two-pagination",
							clickable: true,
							renderBullet: function(index, className) {
								return '<span class="' + className + '">' + 0 + (index + 1) + "</span>";
							},
						},
					});
					//Hero Content
					$('.hero-content-two').slick({
						slidesToShow: 1,
						slidesToScroll: 1,
						dots: false,
						arrows: true,
						prevArrow: false,
						nextArrow: false,
						asNavFor: '.hero-img-wrap-two'
					});


					$('.hero-img-wrap-two').slick({
						slidesToShow: 1,
						slidesToScroll: 1,
						dots: true,
						fade: true,
						arrows: false,
						prevArrow: "<i class='bx bxs-chevron-left'></i>",
						nextArrow: "<i class='bx bxs-chevron-right' ></i>",
						asNavFor: '.hero-content-two'
					});
					$("#desatination_drop").select2({
						closeOnSelect: true,
						width: 'resolve'
					});
					$(".defult-select-drowpown").select2({
						closeOnSelect: true,
					});
				})(jQuery);
			</script>
		<?php
		}
		?>
		<?php
		$destination = get_terms(
			array(
				'taxonomy' => 'turio-package-destination',
				'hide_empty' => false
			)
		);
		$args  = [
			'posts_per_page' => -1,
			'post_type'      => 'turio-package',
			'orderby'        => 'date',
			'order'          => 'DSE',
		];
		$query   = new \WP_Query($args);

		?>
		<div class="hero-area hero-style-two">
			<?php if (!empty($settings['turio_slider_search_switcher'] == 'yes')) : ?>
				<div class="container">
					<div class="multi-main-searchber">
						<form method="get" action="<?php echo get_post_type_archive_link('turio-package'); ?>">
							<div class="row g-4">
								<div class="col-lg-10">
									<div class="row gx-0 gy-4">
										<div class="col-lg-3 col-md-6">
											<div class="search-box-single destination-box">
												<div class="searchbox-icon">
													<i class="bi bi-geo-alt"></i>
												</div>
												<div class="searchbox-input">
													<label><?php echo esc_html__('Destination', 'turio-core') ?></label>
													<select data-placeholder="Where Are You Going?" class="defult-select-drowpown" name="destination">
														<option value=""><?php echo esc_html__('Where Are You Going?', 'turio-core') ?></option>
														<?php
														if (!empty($destination)) {
															foreach ($destination as  $value) {
																if ($value->parent == 0) {
																	echo '<optgroup label="' . esc_html($value->name) . '">';
																	$id = $value->term_id;
																	foreach ($destination as  $value) {

																		if ($id == $value->parent) {
																			echo '<option value="' . $value->term_id . '">' . esc_html($value->name) . '</option>';
																		} elseif ($id == $value->term_id) {
																			echo '<option value="' . $value->term_id . '">' . esc_html($value->name) . '</option>';
																		}
																	}
																	echo '</optgroup>';
																}
															}
														}
														?>
													</select>
												</div>
											</div>
										</div>

										<div class="col-lg-3 col-md-6">
											<div class="search-box-single type-box">
												<div class="searchbox-icon">
													<i class="bi bi-text-paragraph"></i>
												</div>

												<div class="searchbox-input">
													<label>
														<?php echo esc_html__('Travel Type', 'turio-core'); ?>
													</label>
													<select name="travel_type" class="defult-select-drowpown" data-placeholder="<?php echo esc_attr('All Activity') ?>">
														<option value=""><?php echo esc_html__('All Activity', 'turio-core') ?></option>
														<?php 
															$category = get_terms('turio-package-type');
															foreach ($category as $cat) { ?>
																<option value="<?php echo sprintf(__('%s', 'turio-core'), $cat->name) ?>"><?php echo sprintf(__('%s', 'turio-core'), $cat->name) ?></option>
															<?php
															}
														?>
													</select>
												</div>
											</div>
										</div>
										<div class="col-lg-3 col-md-6">
											<div class="search-box-single type-box">
												<div class="searchbox-icon">
													<i class="bx bx-time"></i>
												</div>
												<div class="searchbox-input">
													<label><?php echo esc_html__('Duration', 'turio-core') ?></label>
													<input type="text" name="duration" placeholder="Please type duration ">
												</div>
											</div>
										</div>
										<div class="col-lg-3 col-md-6">
											<div class="search-box-single date-box">
												<div class="searchbox-icon">
													<i class="bi bi-capslock"></i>
												</div>
												<div class="searchbox-input date-picker-input">
													<label for="datepicker"><?php echo esc_html__('Journy Date', 'turio-core') ?></label>
													<input placeholder="Select your date" type="text" name="checkIn" id="datepicker" value="" class="calendar" autocomplete="off">
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-2">
									<div class="main-form-submit">
										<button type="submit"><?php echo esc_html__('Find Now', 'turio-core') ?></button>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			<?php endif ?>

			<div class="hero-main-wrapper position-relative">
				<div class="swiper hero-slider-two">
					<div class="swiper-wrapper">
						<?php

						if (!empty($settings['turio_slider_list_item'])) {
							foreach ($settings['turio_slider_list_item'] as $item) {
								$btn_url_one = $item['slider_button_one_url']['url'];
								$btn_target_one = $item['slider_button_one_url']['is_external'] ? ' target="_blank" ' : '';
								$btn_nofollow_one = $item['slider_button_one_url']['nofollow'] ? ' rel="nofollow"' : '';
								$btn_url_two = $item['slider_button_two_url']['url'];
								$btn_target_two = $item['slider_button_two_url']['is_external'] ? ' target="_blank" ' : '';
								$btn_nofollow_two = $item['slider_button_two_url']['nofollow'] ? ' rel="nofollow"' : '';
						?>


								<div class="swiper-slide single-hero-slide">
									<div class="container">
										<div class="row align-items-center">
											<div class="col-lg-6">
												<div class="hero-content">
													<?php
													if (!empty($item['slider_sub_title'])) {
														$icon = '';
														if ('yes' == $settings['turio_slider_icon_switcher']) {
															$icon = '<i class="bi bi-geo-alt"></i>';
														}
														echo '<h5 class="featured-location">' . $icon . esc_html($item['slider_sub_title']) . '</h5>';
													}
													?>

													<?php
													if (!empty($item['slider_title'])) {
														echo '<h2 class="hero-title">' . wp_kses($item['slider_title'], wp_kses_allowed_html('post')) . '</h2>';
													}
													?>
													<?php
													if (!empty($item['slider_price'])) {
														echo '<h3 class="featured-price">' . esc_html($item['slider_price']) . '</h3>';
													}
													?>
													<?php
													if (!empty($item['slider_description'])) {
														echo '<p>' . esc_html($item['slider_description']) . '</p>';
													}
													?>

													<div class="hero-btns">
														<?php
														if (!empty($item['slider_button_one_text'])) {
														?>
															<a class="button-fill-round" href="<?php echo esc_url($btn_url_one) ?>" <?php echo esc_attr($btn_target_one . ' ' . $btn_nofollow_one) ?>>
																<?php echo $item['slider_button_one_text']; ?>
															</a>
														<?php
														}
														if (!empty($item['slider_button_two_text'])) {
														?>
															<a class="button-fill-round" href="<?php echo esc_url($btn_url_two) ?>" <?php echo esc_attr($btn_target_two . ' ' . $btn_nofollow_two) ?>>
																<?php
																echo wp_kses($item['slider_button_two_text'], wp_kses_allowed_html('post'));
																?>
															</a>
														<?php
														}
														?>
													</div>
												</div>
											</div>
											<div class="col-lg-6">
												<div class="hero-image-group">
													<?php
													if (!empty($item['slider_image']['url'])) {
														echo '<img src="' . esc_url($item['slider_image']['url']) . '" alt="' . esc_attr('travel-image') . '">';
													}
													?>
												</div>
											</div>
										</div>
									</div>
								</div>
						<?php
							}
						}
						?>

					</div>
				</div>

				<?php if ('yes' == $settings['turio_slider_paginate_switcher']) : ?>
					<div class="hero-two-pagination d-lg-inline-flex flex-column  d-none w-auto"></div>
				<?php endif; ?>

			</div>
		</div>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Banner_Slider_Two_Widget());
