<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Banner_Slider_four_Widget extends Widget_Base
{

	public function get_name()
	{
		return 'turio_slider_four';
	}

	public function get_title()
	{
		return esc_html__('TX Slider Four', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{


		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__('General', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_slider_four_image_or_video_selection',
			[
				'label'   => esc_html__('Select Image or Video', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'image_selection'  => esc_html__('Image', 'turio-core'),
					'video_selection' => esc_html__('Video', 'turio-core'),
				],
				'default' => 'video_selection',
			]
		);
		$this->add_control(
			'turio_slider_four_plane_icon_enable',
			[
				'label' 		=> esc_html__( 'Show Plane Icon', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->add_control(
			'turio_slider_four_star1_icon_enable',
			[
				'label' 		=> esc_html__( 'Show Star Icon 1', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->add_control(
			'turio_slider_four_star2_icon_enable',
			[
				'label' 		=> esc_html__( 'Show Star Icon 2', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->add_control(
			'turio_slider_four_star3_icon_enable',
			[
				'label' 		=> esc_html__( 'Show Star Icon 3', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->add_control(
			'turio_slider_four_navigation_enable',
			[
				'label' 		=> esc_html__( 'Show Navigation (prev/next)', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__( 'Enable', 'turio-core' ),
				'label_off' 	=> esc_html__( 'Disable', 'turio-core' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_slider',
			[
				'label' => esc_html__('Slider Section', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'slider_four_image',
			[
				'label'   => esc_html__('Choose Image', 'turio-core'),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        
		$repeater->add_control(
			'slider_four_main_title',
			[
				'label'       => esc_html__('Main Title', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('ENJOY YOUR HOLIDAYS WITH TRAVEL', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_four_description',
			[
				'label'       => esc_html__('Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('A charitable organization or charity is an organization whose primary objectives are philanthr', 'turio-core'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'slider_button_four',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'slider_button_four_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Explore Now', 'turio-core'),
			]
		);

		$repeater->add_control(
			'slider_button_four_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);

		$this->add_control(
			'turio_slider_list_item',
			[
				'label' => __('Slider Items', 'turio-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'slider_four_main_title' => esc_html__( 'ENJOY YOUR HOLIDAYS WITH TRAVEL', 'turio-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'turio-core' ),
					],
					[
						'slider_four_main_title' => esc_html__( 'ENJOY YOUR HOLIDAYS WITH TRAVEL', 'turio-core' ),
						'list_content' => esc_html__( 'Item content. Click the edit button to change this text.', 'turio-core' ),
					],
				],
				'title_field' => '{{slider_four_main_title}}',
			]
		);


		$this->end_controls_section();
		//Video Content Start
		$this->start_controls_section(
			'video_section_general',
			[
				'label' => esc_html__('Video Section', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'video_selection',
				],
			]
		);

		$this->add_control(
			'video_controller',
			[
				'label' => esc_html__('Choose Video', 'turio-core'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'turio_sl4_video_muted_controller',
			[
				'label' 		=> esc_html__('Muted', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('On', 'turio-core'),
				'label_off' 	=> esc_html__('Off', 'turio-core'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'video_selection',
				],
			]
		);
		$this->add_control(
			'slider_video_main_title',
			[
				'label'       => esc_html__('Main Title', 'turio-core'),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__('Move The Earth', 'turio-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_four_description',
			[
				'label'       => esc_html__('Description', 'turio-core'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__('Sed convallis sit amet leo quis feugiat. Nunc interdum mollis facilisis. feugi Donec id the urna aliquet, suscipit turpis ut Donec id urna aliquet, suscipit turpis ut, facilisis purus.Sed convallis sit amet leo quis .', 'turio-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'slider_video_button_one',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'slider_button_four_text',
			[
				'label'   => esc_html__('Text', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Explore Now', 'turio-core'),
			]
		);

		$this->add_control(
			'slider_video_button_one_url',
			[
				'label'         => esc_html__('Link', 'turio-core'),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__('https://your-link.com', 'turio-core'),
				'show_external' => true,
				'default'       => [
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => true,
				]
			]
		);
		$this->add_responsive_control(
			'slider_video_content_alignment',
			[
				'label' 		=> esc_html__( 'Alignment', 'turio-core' ),
				'type' 			=> \Elementor\Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => esc_html__( 'Left', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__( 'Center', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__( 'Right', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => esc_html__( 'Justified', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'center',
				'selectors' 	=> [
					'{{WRAPPER}} .hero4-content ' 	                        => 'text-align: {{VALUE}};',		
				],
			]
		);
		$this->end_controls_section();

        //style section start here

		//Main Title Style
		$this->start_controls_section(
			'slider_main_title_style',
			[
				'label' => esc_html__('Main Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'main_title_typography',
				'selector' => '{{WRAPPER}} .hero-style-four .hero4-content h1,.home-four-hero .video-wrap .hero4-content h1,.home-four-hero .video-wrap .hero4-content h1',

			]
		);

		$this->add_control(
			'turio_main_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-four .hero4-content h1' => 'color: {{VALUE}} ;',
					'{{WRAPPER}} .home-four-hero .video-wrap .hero4-content h1' => 'color: {{VALUE}} ;',
				],
			]
		);

		
		$this->add_responsive_control(
			'turio_main_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-four .hero4-content h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-four-hero .video-wrap .hero4-content h1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

        $this->add_responsive_control(
            'turio_main_title_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .hero-style-four .hero4-content h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .home-four-hero .video-wrap .hero4-content h1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();

		// Description Title Style
		$this->start_controls_section(
			'slider_sub_title_style',
			[
				'label' => esc_html__('Description', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .hero-style-four .hero4-content p,.home-four-hero .video-wrap .hero4-content p',

			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hero-style-four .hero4-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .home-four-hero .video-wrap .hero4-content p' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'turio_sub_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .hero-style-four .hero4-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .home-four-hero .video-wrap .hero4-content p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

        $this->add_responsive_control(
            'turio_sub_title_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .hero-style-four .hero4-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .home-four-hero .video-wrap .hero4-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();

		// Start  Navigation Icon Style
		$this->start_controls_section(
			'turio_slider_four_navigation_icon_style',
			[
				'label'  		=> esc_html__('Navigation (Prev/Next)','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_slider_four_image_or_video_selection' => 'image_selection',
				],
			]
		);
        $this->add_control(
            'turio_slider_four_navigation_icon_style_color',
            [
                'label'     	=> esc_html__('Icon Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3' => 'color: {{VALUE}};',
                  

                ],
            ]
        );
        $this->add_control(
            'turio_slider_four_navigation_icon_border_style_color',
            [
                'label'     	=> esc_html__('Border Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                  
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3' => 'border:1px solid {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3' => 'border:1px solid {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'turio_slider_four_navigation_icon_bg_style_color',
            [
                'label'     	=> esc_html__('Background Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'turio_slider_four_navigation_icon_style_hover_color',
            [
                'label'     	=> esc_html__('Hover Icon Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3:hover' => 'color: {{VALUE}};',
					
                ],
            ]
        );
        $this->add_control(
            'turio_slider_four_navigation_icon_style_border_hover_color',
            [
                'label'     	=> esc_html__('Hover Border Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    
					'{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3:hover' => 'border:1px solid {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3:hover' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'turio_slider_four_navigation_icon_style_bg_hover_color',
            [
                'label'     	=> esc_html__('Hover Background Color', 'turio-core'),
                'type'      	=> Controls_Manager::COLOR,
                'selectors' 	=> [
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-prev3:hover' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .hero-style-four .slider-arrows .hero-next3:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
       

		$this->end_controls_section();

		// Start Button Widget Style
		$this->start_controls_section(
			'turio_button_widget',
			[
				'label' => esc_html__('Button', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_button_widget_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .button-fill-primary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);

		$this->add_responsive_control(
			'turio_button_widget_margin',
			[
				'label'        => __('Margin', 'turio-core'),
				'type'         => Controls_Manager::DIMENSIONS,
				'size_units'   => ['px', '%'],
				'selectors'    => [
					'{{WRAPPER}} .button-fill-primary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->start_controls_tabs('_tab_button');

		$this->start_controls_tab(
			'_tab_button_normal',
			[
				'label' => __('Normal', 'turio-core'),
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-fill-primary' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'turio_button_widget_background_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-fill-primary' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'turio_button_widget',
				'label' => __('Border', 'turio-core'),
				'selector' => '{{WRAPPER}} .button-fill-primary',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_typography',
				'selector' => '{{WRAPPER}} .button-fill-primary',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .button-fill-primary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __('Hover', 'turio-core'),
			]
		);

		$this->add_control(
			'button_hover_color',
			[
				'label' => __('Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-fill-primary:hover' => 'color: {{VALUE}};',

				],
			]
		);

		$this->add_control(
			'button_hover_bg_color',
			[
				'label' => __('Background Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-fill-primary:hover' => 'background-color: {{VALUE}};',
				],
			]
		);


		$this->add_control(
			'button_hover_border_color',
			[
				'label' => __('Border Color', 'turio-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .button-fill-primary:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'turio-core'),
				'name' => 'elency_call_to_action_button_hover_typography',
				'selector' => '{{WRAPPER}} .button-fill-primary:hover',

			]
		);

		$this->add_responsive_control(
			'elency_call_to_action_button_hover_border_radius',
			[
				'label'      => __('Border Radius', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .button-fill-primary:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);


		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();

		
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$data=$settings['turio_slider_list_item'];

		?>
		<?php if (is_admin()): ?>
			<script>
				 var heroSliderTwo = new Swiper(".hero-slider-four", {
                    slidesPerView: 1,
                    speed: 1500,
                    loop: true,
                    spaceBetween: 0,
                    loop: true,
                    centeredSlides: true,
                    roundLengths: true,
                    effect: "fade",
                    navigation: {
                    nextEl: ".hero-next3",
                    prevEl: ".hero-prev3",
                    },

                    autoplay: {
                    delay: 5000,
                    },
                    pagination: {
                    el: ".hero-two-pagination",
                    clickable: true,
                    renderBullet: function (index, className) {
                        return '<span class="' + className + '">' + 0 + (index + 1) + "</span>";
                    },
                    },
                });
			</script>
		<?php endif ?>
		
		<?php if (!empty($settings['turio_slider_four_image_or_video_selection']) && ($settings['turio_slider_four_image_or_video_selection'] == 'image_selection')) : ?>

			<div class="hero-area hero-style-four">
				<?php if ( 'yes' === $settings['turio_slider_four_plane_icon_enable'] ): ?>
					<img src="<?php echo get_template_directory_uri() ?>/assets/images/banner/banner-plane.svg" class="img-fluid banner-plane">
				<?php endif ?>
				<?php if ( 'yes' === $settings['turio_slider_four_star1_icon_enable'] ): ?> 
					<img src="<?php echo get_template_directory_uri() ?>/assets/images/banner/banner-star1.svg" class="banner-star1" alt="">
				<?php endif ?>
				<?php if ( 'yes' === $settings['turio_slider_four_star2_icon_enable'] ): ?> 
					<img src="<?php echo get_template_directory_uri() ?>/assets/images/banner/banner-star2.svg" class="banner-star2" alt="">
				<?php endif ?>
				<?php if ( 'yes' === $settings['turio_slider_four_star3_icon_enable'] ): ?> 
					<img src="<?php echo get_template_directory_uri() ?>/assets/images/banner/banner-star3.svg" class="banner-star3" alt="">
				<?php endif ?>
				<div class="hero-main-wrapper position-relative">
					
					<div class="swiper hero-slider-four">
						<div class="swiper-wrapper">

							<?php foreach($data as $item): ?>
								<div class="swiper-slide">
									<?php if( !empty( $item['slider_four_image']['url'] ) ) : ?>
										<div class="home4-banner1-bg">
											<img src="<?php echo esc_url($item['slider_four_image']['url']) ?>" alt="<?php echo esc_attr('image','turio-core') ?>">
										</div>
									<?php endif ?>
									<div class="container">
										<div class="row d-flex justify-content-lg-start justify-content-center align-items-center">
											<div class="col-xl-7 col-lg-7">
												<div class="hero4-content">
													<?php if( !empty( $item['slider_four_main_title'] ) ) : ?>
													<h1 ><?php echo wp_kses( $item['slider_four_main_title'],wp_kses_allowed_html('post') )?></h1>
													<?php endif ?>
													<?php if( !empty( $item['slider_four_description'] ) ) : ?>
													<p ><?php echo wp_kses( $item['slider_four_description'],wp_kses_allowed_html('post') )?></p>
													<?php endif ?>
													<?php if( !empty( $item['slider_button_four_text']) ) : ?>
														<a href="<?php echo esc_url($item['slider_button_four_url']['url']) ?>" class="button-fill-primary banner3-btn">
															<?php echo esc_html($item['slider_button_four_text']) ?>
														</a>
													<?php endif ?>
												</div>
											</div>
										</div>
									</div>
								</div>
							<?php endforeach ?>
							
						</div>
					</div>
					<?php if ( 'yes' === $settings['turio_slider_four_navigation_enable'] ): ?>
						<div class="slider-arrows text-center d-lg-flex flex-column d-none gap-5">
							<div class="hero-prev3" tabindex="0" role="button" aria-label="Previous slide"> <i class="bi bi-arrow-left"></i></div>
							<div class="hero-next3" tabindex="0" role="button" aria-label="Next slide"><i class="bi bi-arrow-right"></i></div>
						</div>
					<?php endif ?>
				</div>
			</div>
		<?php endif ?>

		<?php if (!empty($settings['turio_slider_four_image_or_video_selection']) && ($settings['turio_slider_four_image_or_video_selection'] == 'video_selection')) : ?>
			<?php

						$btn_url_one = $settings['slider_video_button_one_url']['url'];
						$btn_target_one = $settings['slider_video_button_one_url']['is_external'] ? ' target="_blank" ' : '';
						$btn_nofollow_one = $settings['slider_video_button_one_url']['nofollow'] ? ' rel="nofollow"' : '';
						?>

			<div class="home-four-hero">
					<div class="video-wrap">
					<video autoplay loop="loop"
						<?php echo $settings['turio_sl4_video_muted_controller'] == 'yes' ? 'muted' : '' ?> 
						preload="auto">
						<?php if (!empty($settings['video_controller']['url'])) :   ?>
							<source src="<?php echo $settings['video_controller']['url'] ?>" type="video/mp4">
						<?php endif ?>
					</video>
					<div class="hero4-content">
							<?php if( !empty( $settings['slider_video_main_title'] ) ) : ?>
							<h1 ><?php echo wp_kses( $settings['slider_video_main_title'],wp_kses_allowed_html('post') )?></h1>
							<?php endif ?>
							<?php if( !empty( $settings['slider_four_description'] ) ) : ?>
							<p ><?php echo wp_kses( $settings['slider_four_description'],wp_kses_allowed_html('post') )?></p>
							<?php endif ?>
							<?php if( !empty( $settings['slider_button_four_text']) ) : ?>
								<a class="button-fill-primary banner3-btn" href="<?php echo esc_url($btn_url_one) ?>" <?php echo esc_attr($btn_target_one . ' ' . $btn_nofollow_one) ?>>
									<?php
									echo $settings['slider_button_four_text'];
									?>
								</a>
							<?php endif ?>
						</div>
					</div>

			</div>

		<?php endif ?>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Banner_Slider_four_Widget());