<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class turio_newsletter extends Widget_Base
{

    public function get_name()
    {
        return 'turio_newsletter';
    }

    public function get_title()
    {
        return esc_html__('TX NewsLetter One', 'turio-core');
    }

    public function get_icon()
    {
        return 'eicon-mail';
    }

    public function get_categories()
    {
        return ['turio_widgets'];
    }

    protected function register_controls()
    {

        //Title Section
        $this->start_controls_section(
            'turio_newsletterone_title',
            [
                'label' => esc_html__('Title', 'turio-core')
            ]
        );
        // Title Control
        $this->add_control(
            'turio_newsletterone_title_section',
            [
                'label' => esc_html__( 'Title', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Get 20% OFF Your First', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your title here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section();  
        //Description Section
        $this->start_controls_section(
            'turio_newsletterone_description',
            [
                'label' => esc_html__('Description', 'turio-core')
            ]
        );
        // Description Control
        $this->add_control(
            'turio_newsletterone_description_section',
            [
                'label' => esc_html__( 'Description', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__( 'Don’t Wanna Miss Somethings? Subscribe Right Now & Get The Special Discount & Monthly Newsletter.', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your description here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section(); 
        //Shortcode Section
        $this->start_controls_section(
            'turio_newsletterone_shortcode',
            [
                'label' => esc_html__('Shortcode', 'turio-core')
            ]
        );
        // Text Control
        $this->add_control(
            'turio_newsletterone_shortcode_section',
            [
                'label' => esc_html__( 'Shortcode', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your shortcode here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        $this->end_controls_section(); 

        $this->start_controls_section(
            'turio_newsletterone_featureitemas',
            [
                'label' => esc_html__('Feature Items', 'turio-core')
            ]
        );

        // Repeater
        $repeater = new \Elementor\Repeater();
        
        // Icon
         $repeater->add_control(
            'turio_newsletterone_featureitemas_icon',
            [
                'label' => esc_html__( 'Icon', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );
        // Number
        $repeater->add_control(
            'turio_newsletterone_featureitemas_number',
            [
                'label' => esc_html__( 'Number', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '500', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your feature number here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        // Name
         $repeater->add_control(
            'turio_newsletterone_featureitemas_name',
            [
                'label' => esc_html__( 'Feature Name', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Awesome Tour', 'turio-core' ),
                'placeholder' => esc_html__( 'Type your feature name here', 'turio-core' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'turio_newsletterone_featureitemas_repeat',
            [
                'label' => esc_html__( 'Feature Lists', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'turio_newsletterone_featureitemas_name' => esc_html__( 'Awesome Tour', 'turio-core' ),
                    ],
                ],
                'title_field' => '{{{ turio_newsletterone_featureitemas_name }}}',
            ]
        );
        
        $this->end_controls_section();  
        // -------------Style Start -----------------//

        //Background Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_background',
             [
             'label' => esc_html__('Background', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        // Background Control
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_turio_newslatter',
                'label' => esc_html__( 'Background', 'turio-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .newsletter-section3',
                'fields_options' => [
					'background' => [
						'label' => esc_html__('Background (Color/Image)', 'turio-core'),
						'default' => 'classic',
					],
				],
            ]
        );
        $this->end_controls_section();

        //Title Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_title',
             [
             'label' => esc_html__('Title', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        // Color
        $this->add_control(
            'turio_newsletterone_featureitemas_style_title_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .newslatter-side h2' => 'color: {{VALUE}};',
                ],
            ]
        );
        // Typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_newsletterone_featureitemas_style_title_typ',
                'selector' => '{{WRAPPER}} .newslatter-side h2',

            ]
        );
        //Padding
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .newslatter-side h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        // Margin
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_title_margin',
			[
				'label' => esc_html__( 'Margin', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .newslatter-side h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();

        //Stroke Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_stroke',
             [
             'label' => esc_html__('Stroke Text', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        $this->add_control(
            'turio_newsletterone_featureitemas_style_stroke_col',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .newsletter-section3 .newslatter-side h2 span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_newsletterone_featureitemas_style_stroke_typ',
                'selector' => '{{WRAPPER}} .newsletter-section3 .newslatter-side h2 span',

            ]
        );
        $this->end_controls_section();

        //Description Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_description',
             [
             'label' => esc_html__('Description', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        $this->add_control(
            'turio_newsletterone_featureitemas_style_description_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .newsletter-section3 .newslatter-side p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_newsletterone_featureitemas_style_description_typ',
                'selector' => '{{WRAPPER}} .newsletter-section3 .newslatter-side p',

            ]
        );
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_description_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .newsletter-section3 .newslatter-side p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_description_mar',
			[
				'label' => esc_html__( 'Margin', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .newsletter-section3 .newslatter-side p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
        //Feature Icon Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_feature_icon',
             [
             'label' => esc_html__('Feature Icon & SVG', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        //SVG Color
        $this->add_control(
            'turio_news_svg_color',
            [
                'label' => esc_html__( 'SVG Color', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .counter-single .icon svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );
        // SVG Size
        $this->add_control(
            'turio_news_talk_svg_size',
            [
                'label' => esc_html__( 'SVG Size', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 58,
                ],
                'selectors' => [
                    '{{WRAPPER}} .feature-section .counter-single .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        //Icon color
        $this->add_control(
            'turio_news_icon color',
            [
                'label' => esc_html__( 'Icon Color', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .counter-single .icon i' => 'color: {{VALUE}}',
                ],
            ]
        );  
        // Icon Size
        $this->add_control(
            'turio_news_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 58,
                ],
                'selectors' => [
                    '{{WRAPPER}} .counter-single .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        //Feature Number Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_feature_num',
             [
                'label' => esc_html__('Feature Number', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        $this->add_control(
            'turio_newsletterone_featureitemas_style_feature_num_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
				'default'   => '#2D373C',
                'selectors' => [
                    '{{WRAPPER}} .feature-section .counter-single h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_newsletterone_featureitemas_style_feature_num_typ',
                'selector' => '{{WRAPPER}} .feature-section .counter-single h3',

            ]
        );
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_feature_num_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .feature-section .counter-single h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_feature_num_margin',
			[
				'label' => esc_html__( 'Margin', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .feature-section .counter-single h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        
        
        $this->end_controls_section();

        //Feature Name Style
        $this->start_controls_section(
             'turio_newsletterone_featureitemas_style_feature_name',
             [
             'label' => esc_html__('Feature Name', 'turio-core'),
             'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );
        $this->add_control(
            'turio_newsletterone_featureitemas_style_feature_name_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-section .counter-single p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_newsletterone_featureitemas_style_feature_name_typography',
                'selector' => '{{WRAPPER}} .feature-section .counter-single p',

            ]
        ); 
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_feature_name_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .feature-section .counter-single p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
			'turio_newsletterone_featureitemas_style_feature_name_margin',
			[
				'label' => esc_html__( 'Margin', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .feature-section .counter-single p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
        //Feature Card Style
        $this->start_controls_section(
            'turio_feature_card',
            [
               'label' => esc_html__('Feature Card', 'turio-core'),
               'tab'   => Controls_Manager::TAB_STYLE,
            ]
       );
       $this->add_control(
           'turio_feature_card_background',
           [
               'label' => esc_html__( 'Background Color', 'turio-core' ),
               'type' => \Elementor\Controls_Manager::COLOR,
               'selectors' => [
                   '{{WRAPPER}} .feature-section .counter-single' => 'background: {{VALUE}}',
               ],
           ]
       );
       $this->add_responsive_control(
        'turio_feature_card_border_radius',
        [
            'label'      	=> __('Border Radius', 'turio-core'),
            'type'       	=> Controls_Manager::DIMENSIONS,
            'size_units' 	=> ['px', '%'],
            'selectors'  	=> [
                '{{WRAPPER}} .feature-section .counter-single' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
            ]
        ]
    );
       $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
            'name' 			=> 'turio_feature_card_box_shadow_style',
            'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
            'selector' 		=> '{{WRAPPER}} .feature-section .counter-single',
        ]
    );
       $this->end_controls_section();
       
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $features = $settings['turio_newsletterone_featureitemas_repeat'];
        
	?>

	<script>
		<?php if(is_admin()) :  ?>
		( function( $ ) {
				$(".counter-single").each(function () {
					$(this).isInViewport(function (status) {
					if (status === "entered") {
						for (var i = 0; i < document.querySelectorAll(".odometer").length; i++) {
						var el = document.querySelectorAll('.odometer')[i];
						el.innerHTML = el.getAttribute("data-odometer-final");
						}
					}
					});
				});
		} )( jQuery );
		<?php endif ?>
	 </script>


    <div  class="newsletteronewithfeature">

        <div class="newsletter-section3 pt-120">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="newslatter-side text-center mx-auto mx-lg-0">
                            <?php if( !empty( $settings['turio_newsletterone_title_section'] ) ) :   ?>
                                   <h2>
                                        <?php echo wp_kses($settings['turio_newsletterone_title_section'],wp_kses_allowed_html( 'post' )) ?>                               
                                    </h2>         
                            <?php endif ?>
                            <?php if( !empty( $settings['turio_newsletterone_description_section'] ) ) :   ?>
                                     <p><?php echo esc_html( $settings['turio_newsletterone_description_section'] )?></p>       
                            <?php endif ?>
                            <?php echo do_shortcode(  $settings['turio_newsletterone_shortcode_section'] ) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="feature-section">
            <div class="container-xl container-lg-fluid">
                <div class="row g-4">

                    <?php
					$num = 0;
					foreach ($features as $feature):
					$num++;
					?>

                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="counter-single wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
                                <?php if( !empty( $feature['turio_newsletterone_featureitemas_icon'] ) ) :   ?>
                                    <div class="icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $feature['turio_newsletterone_featureitemas_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>          
                                <?php endif ?>
                                <div class="coundown d-flex flex-column">
                                    <h3 class="odometer" data-odometer-final="<?php echo esc_html( $feature['turio_newsletterone_featureitemas_number'] )?>">&nbsp;</h3>
                                    <p><?php echo esc_html( $feature['turio_newsletterone_featureitemas_name'] )?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                    

                </div>
            </div>
        </div>

    </div>


<?php

    }
}

Plugin::instance()->widgets_manager->register(new turio_newsletter());
