<?php

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use Elementor\core\Schemes;

class turio_hotspot extends Widget_Base
{

    public function get_name()
    {
        return 'turio_hotspot';
    }

    public function get_title()
    {
        return esc_html__('TX Hot spot', 'turio-core');
    }

    public function get_icon()
    {
        return 'eicon-hotspot';
    }

    public function get_categories()
    {
        return ['turio_widgets'];
    }

    protected function register_controls()
    {
        //Content Section
        $this->start_controls_section(
            'turio_hotspot',
            [
                'label' => esc_html__('General', 'turio-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'turio_hotspot_title',
            [
                'label' => esc_html__( 'Locations', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'default' =>  esc_html__( 'traditional', 'turio-core' ),
            ]
        );

        $this->add_control(
            'elency_hotspot_image',
            [
                'label' => __('Image', 'turio-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'turio_hotspot_position_top_bottom',
			[
				'label' => esc_html__( 'Horizontal', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $repeater->add_control(
			'turio_hotspot_position_left_right',
			[
				'label' => esc_html__( 'Vertical', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $repeater->add_control(
            'turio_hotspot_text',
            [
                'label'       => esc_html__('Location Name', 'turio-core'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('China', 'turio-core'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'turio_hotspot_textarea',
            [
                'label'       => esc_html__('Description', 'turio-core'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Sed rhoncus eros eu est faucibuses rhoncus. In lobortis, ex sit ametend ultricies blandit, dui arcu conguepor urna eu ultricies metus.', 'turio-core'),
                'label_block' => true,
            ]
        );
 
        $repeater->add_control(
            'turio_icon_box_icon',
            [
                'label' => esc_html__('Choose Icon', 'turio-core'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'bi bi-geo-alt-fill',
                    'library' => 'solid',
                ],
                'label_block' => true
            ]
        );

         $this->add_control(
             'turio_brand_items',
             [
                 'label' => __( 'Locations List', 'turio-core' ),
                 'type' => \Elementor\Controls_Manager::REPEATER,
                 'fields' => $repeater->get_controls(),
                 'default'	=> [
                     [
                         'turio_hotspot_text'          => esc_html__( 'Item 1', 'turio-core' ),
                         'turio_brand_item_default_active' => 'yes'
                     ],
                     [ 'turio_hotspot_text' => esc_html__( 'Item 2', 'turio-core' ) ],
                     [ 'turio_hotspot_text' => esc_html__( 'Item 3', 'turio-core' ) ],
                 ],
                 'title_field' => '{{turio_hotspot_text}}'
               ,
             ]
         );

        $this->end_controls_section();


        //Style Section
        $this->start_controls_section(
            'turio_heading_icon_style',
            [
                'label' => esc_html__('Icon', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_heading_icon_typography',
                'selector' => '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-icon i',

            ]
        );

        $this->add_control(
            'turio_heading_icon_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-icon i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'turio_heading_title_style',
            [
                'label' => esc_html__('Location Name', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'turio_heading_title_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-disc h6' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_heading_title_typography',
                'selector' => '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-disc h6',

            ]
        );

        $this->end_controls_section();

        // Description Style
        $this->start_controls_section(
            'turio_heading_description_style',
            [
                'label' => esc_html__('Description', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'turio_heading_description_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-disc p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Typography', 'turio-core'),
                'name'     => 'turio_heading_description_typography',
                'selector' => '{{WRAPPER}} .world-map-area .world-map-wrap .single-location .location-disc p',

            ]
        );

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings_for_display();
?>
    <div class="world-map-area">
        <div class="container-fluid">
            <div class="world-map-wrap">
                <div class="world-map-background">
                    <img src="<?php echo esc_url($settings['elency_hotspot_image']['url'])?>" alt="map">
                </div>
                <?php

                $i = 0;
                if( $settings['turio_brand_items'] ):
                    foreach( $settings['turio_brand_items'] as $item ):
                $i++;
                ?>
                <div class="single-location elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?>">
                    <div class="location-icon">
                        <?php \Elementor\Icons_Manager::render_icon( $item['turio_icon_box_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                    <div class="location-disc">
                        <h6>
                            <?php
                                if (!empty($item['turio_hotspot_text'])) {
                                    echo $item['turio_hotspot_text'];
                                }
                            ?>
                        </h6>
                        <p>
                            <?php
                                if (!empty($item['turio_hotspot_textarea'])) {
                                    echo $item['turio_hotspot_textarea'];
                                }
                            ?>
                        </p>
                    </div>
                </div>

                <?php 
                    endforeach;
                    endif;
                ?>

            </div>
        </div>
    </div>

<?php

    }
}

Plugin::instance()->widgets_manager->register(new turio_hotspot());
