<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioHeadingWidget extends Widget_Base {

	public function get_name() {
		return 'turio_heading';
	}

	public function get_title() {
		return esc_html__( 'TX Heading', 'turio-core' );
	}

	public function get_icon() {
		return ' eicon-t-letter-bold';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// Start General Section
		$this->start_controls_section(
			'general_section',
			[
				'label' 		=> esc_html__( 'General', 'turio-core' ),
			]
		);
		$this->add_responsive_control(
			'turio_heading_title_align',
			[
				'label' 		=> esc_html__( 'Alignment', 'turio-core' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 		=> [
						'title' => esc_html__( 'Left', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' => esc_html__( 'Center', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' => esc_html__( 'Right', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-right',
					],
					'justify' 	=> [
						'title' => esc_html__( 'Justified', 'turio-core' ),
						'icon' 	=> 'eicon-text-align-justify',
					],
				],
				'default' 		=> 'left',
				'selectors' 	=> [
					'{{WRAPPER}} .turio-heading-area' 	  => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		// End General Section
		// Start Subtitle Content
		$this->start_controls_section(
			'section_subtitle',
			[
				'label' 		=> esc_html__( 'Subtitle', 'turio-core' ),
				'tab'			=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'turio_heading_subtitle_content',
			[
				'label'			=> esc_html('Subtitle','turio-core'),
				'type'			=> Controls_Manager::TEXT,
				'placeholder'	=> esc_html__('Enter your subtitle','turio-core'),
				'default'		=> esc_html__('This is subtitle element','turio-core'),
				'label_block'	=> true,
			]
		);
		$this->end_controls_section();
        // End Subtitle Content
		// Start Main Title Content
        $this->start_controls_section(
			'section_title',
			[
				'label' 		=> esc_html__( 'Main Title', 'turio-core' ),
			]
		);
		$this->add_control(
			'turio_heading_title',
			[
				'label' 		=> esc_html__( 'Main Title', 'turio-core' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', 'turio-core' ),
				'default' 		=> esc_html__( 'This is main title element', 'turio-core' ),
				'label_block'   => true,
			]
		);
		$this->add_control(
			'turio_heading_title_tags',
			[
				'label' 		=> esc_html__( 'HTML Tag', 'turio-core' ),
				'type' 			=> Controls_Manager::SELECT,
				'options' => [
					'h1' 		=> esc_html__( 'H1', 'turio-core' ),
					'h2' 		=> esc_html__( 'H2', 'turio-core' ),
					'h3' 		=> esc_html__( 'H3', 'turio-core' ),
					'h4' 		=> esc_html__( 'H4', 'turio-core' ),
					'h5' 		=> esc_html__( 'H5', 'turio-core' ),
					'h6' 		=> esc_html__( 'H6', 'turio-core' ),
					'div' 		=> esc_html__( 'div', 'turio-core' ),
					'span' 		=> esc_html__( 'span', 'turio-core' ),
					'p' 		=> esc_html__( 'p', 'turio-core' ),
				],
				'default' 		=> 'h2',
			]
		);
		$this->end_controls_section();
		// End Main Title Content
        // Start Description Content
        $this->start_controls_section(
            'turio_heading_description',
            [
                'label' 		=> esc_html__('Description','turio-core'),
                'tab'   		=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'turio_heading_description_content',
            [
				'label' 		=> esc_html__( 'Description', 'turio-core' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'placeholder' 	=> __( 'Enter your description', 'turio-core' ),
				'default' 		=> __( 'This is description element', 'turio-core' ),
                
            ]
        );
        $this->end_controls_section();
        // End Description Content
		// Start Subtitle Style
		$this->start_controls_section(
			'turio_heading_section_sub_title_style',
			[
				'label' 		=> esc_html__( 'Subtitle', 'turio-core' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_heading_sub_title_style_color',
			[
				'label' 		=> esc_html__( 'Text Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#54A15D',
				'selectors' 	=> [
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-subtitle h4'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_subtitle_typography',
				'selector' 		=> '{{WRAPPER}} .turio-heading-area .heading-section .heading-subtitle h4'
			]
		);
		$this->add_responsive_control(
			'turio_heading_sub_title_style_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .heading-section .heading-subtitle h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
            'turio_heading_sub_title_style_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .heading-section .heading-subtitle h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
        // End Subtitle Style 
        // Start Main Title Style
		$this->start_controls_section(
			'turio_heading_section_title_style',
			[
				'label' 		=> esc_html__( 'Main Title', 'turio-core' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_heading_title_style_color',
			[
				'label' 		=> esc_html__( 'Text Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2d373c',
				'selectors' 	=> [
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h1'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h2'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h3'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h4'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h5'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title h6'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title div'  => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title span' => 'color: {{VALUE}};',
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-title p'    => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_heading_typography',
				'selector' 		=> '{{WRAPPER}} .turio-heading-area .heading-section .heading-title h1,.turio-heading-area .heading-section .heading-title h2,.turio-heading-area .heading-section .heading-title h3,.turio-heading-area .heading-section .heading-title h4,.turio-heading-area .heading-section .heading-title h5,.turio-heading-area .heading-section .heading-title h6,.turio-heading-area .heading-section .heading-title span,.turio-heading-area .heading-section .heading-title p'
			]
		);
		$this->add_responsive_control(
			'turio_heading_main_title_style_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .heading-section .heading-title h1' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h2' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h3' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h4' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h5' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h6' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title div' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title span' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title p' 	=> 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
        $this->add_responsive_control(
            'turio_heading_main_title_style_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors'  => [
					'{{WRAPPER}} .heading-section .heading-title h1' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h2' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h3' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h4' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h5' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title h6' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title div' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title span' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .heading-section .heading-title p' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
            ]
        );
		$this->end_controls_section();
        // End Main Title Style 
        // Start Description Style
        $this->start_controls_section(
			'turio_heading_section__description_style',
			[
				'label' 	   => esc_html__( 'Description', 'turio-core' ),
				'tab' 		   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_heading_description_style_color',
			[
				'label' 	   => esc_html__( 'Text Color', 'turio-core' ),
				'type' 		   => Controls_Manager::COLOR,
                'default' 	   => '#666666',
				'selectors'    => [
					'{{WRAPPER}} .turio-heading-area .heading-section .heading-description  p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 	   => esc_html__('Typography','turio-core'),
				'name' 		   => 'turio_sub_heading_typography',
				'selector'     => '{{WRAPPER}} .turio-heading-area .heading-section .heading-description p'
			]
		);
		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name' 	       => 'description_text_shadow',
				'selector'     => '{{WRAPPER}} .turio-heading-area .heading-section .heading-description p',
			]
		);
		$this->add_responsive_control(
			'turio_heading_description_style_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .heading-section p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
        $this->add_responsive_control(
            'turio_heading_description_style_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .heading-section p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
        // End Description Style

    }
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
				<div class="turio-heading-area wow animate fadeInUp" data-wow-delay="400ms">
					<div class="heading-section">
					<?php if (!empty($settings['turio_heading_subtitle_content'])): ?>
							<div class="heading-subtitle">
								<h4><?php echo $settings['turio_heading_subtitle_content'] ?></h4>
							</div>
						<?php endif ?>
						<?php if (!empty($settings['turio_heading_title'])): ?>
							<div class="heading-title section-head-gamma">
								<?php echo "<".$settings['turio_heading_title_tags'].">".$settings['turio_heading_title']."</".$settings['turio_heading_title_tags'].">"; ?>
							</div>
						<?php endif ?>
						<?php if (!empty($settings['turio_heading_description_content'])): ?>
							<div class="heading-description">
								<p><?php echo $settings['turio_heading_description_content'] ?></p>
							</div>
						<?php endif ?>
						
					</div>
				</div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioHeadingWidget() );