<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioFeaturedDestination extends Widget_Base {

	public function get_name() {
		return 'turio_featured_destination';
	}

	public function get_title() {
		return esc_html__( 'TX Featured Destination', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-featured-image';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
    	// Start Package Destination Section Control
		$this->start_controls_section(
			'section_destination',
			[
				'label' 		=> esc_html__('Destination','turio-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
        // Start Package Destination Control
        $this->add_control(
			'turio_package_destination',
			[
				'label' 		=> __('Destination', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => turio_core()->get_terms_names('turio-package-destination', 'id'),
				'default'       => turio_core()->get_all_terms_names('turio-package-destination','id'),
			]
		);
		$this->add_control(
			'turio_package_destination_order_by',
			[
				'label'   		=> esc_html__('Order By', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'turio-core'),
					'name'    	=> esc_html__('Name', 'turio-core'),
					'include'  	=> esc_html__('Include', 'turio-core'),
				],
			]
		);
		// Start Turio Package Destination Order
		$this->add_control(
			'turio_package_destination_order',
			[
				'label'   		=> esc_html__('Order', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'turio-core'),
					'desc' 		=> esc_html__('Descending', 'turio-core')
				],
				'default' 		=> 'desc',
			]
		);
		// Start Turio Package Destination Order
		$this->add_control(
			'turio_package_destination_count',
			[
				'label'   		=> esc_html__('Destination Count', 'turio-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> 6,
			]
		);
        $this->end_controls_section();
        // End Destination Content Control Section
		// Start Destination Style
		$this->start_controls_section(
			'turio_package_destination_name_style',
			[
				'label'  		=> esc_html__('Destination Name','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_destination_name_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-item .destination-overlay .content h5' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_package_destination_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-item .destination-overlay .content h5'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Style
		$this->start_controls_section(
			'turio_package_destination_place_count_style',
			[
				'label'  		=> esc_html__('Place Count','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_destination_place_count_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-item .destination-overlay .content h6' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_control(
			'turio_package_destination_place_count_style_border_color',
			[
				'label'  		=> esc_html__('Hover Color (Border)','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-item .destination-overlay .content h6::after' => 'background : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_package_destination_place_count_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-item .destination-overlay .content h6'
			]
		);

		$this->end_controls_section();
		// End Package Destination Description Style
    }
	protected function render() {
		$settings = $this->get_settings_for_display(); 

		$destinations = get_terms( array(
			    'taxonomy'   	=> 'turio-package-destination',
			    'include'    	=> $settings['turio_package_destination'],
                'orderby'    	=> $settings['turio_package_destination_order_by'],
                'order'      	=> $settings['turio_package_destination_order'],
				'number'		=> $settings['turio_package_destination_count'],
			) );
		?>


        <div class="swiper destination-slider-one">
			<div class="destination-area destination-style-two">
				<div class="container">
					<div class="row d-flex justify-content-center g-4">
						<?php 
							if ( ! empty( $destinations ) && is_array( $destinations ) ) {
								$i = 0;
							// add links for each category
							foreach ( $destinations as  $destination ) {
								$i++;
									$destination_image = get_term_meta( $destination->term_id, 'turio_destination_image_options', true );
								?>
								<div class="<?php echo ($i == 1 || $i == 6 || $i == 7 || $i == 12 || $i == 13 || $i == 18) ? 'col-lg-6 col-md-12 ' : 'col-lg-3 col-md-6';  ?> col-sm-10 fadeffect">
									<div class="destination-item wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($i+1)*2 ?>00ms">
										<div class="destination-img">
											<?php if( !empty($destination_image['destination_image']['url']) ) : ?>
												<img src="<?php echo $destination_image['destination_image']['url'] ?>" alt="<?php echo $destination_image['destination_image']['alt']; ?>">
											<?php endif ?>
										</div>
										<div class="destination-overlay">
											<div class="content">
												<?php if (!empty($destination->name)) : ?>
													<a href="<?php echo esc_url( get_term_link( $destination ) ) ?>"><h5><?php echo $destination->name ?? '' ?></h5></a>
												<?php endif ?>
												
												<?php if (!empty($destination->count)): ?>
													<a href="<?php echo esc_url( get_term_link( $destination ) ) ?>"><h6><?php echo $destination->count; ?> <?php esc_html_e('Place','turio-core') ?></h6></a>
												<?php endif ?>
											</div>
										</div>
									</div>
								</div>						        
								<?php 
							}
						} ?>
					
					</div>
				</div>
			</div>
        </div>

		<?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioFeaturedDestination() );
