<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioFaqWidget extends Widget_Base {

	public function get_name() {
		return 'turio_faq';
	}

	public function get_title() {
		return esc_html__( 'TX Faq', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-accordion';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		// FAQ Content Section Start
        $this->start_controls_section(
			'section_title',
			[
				'label' 		=> esc_html__( 'Title', 'turio-core' ),
			]
		);
		
		$this->add_control(
			'faq_main_title',
			[
				'label' 		=> esc_html__( 'Title', 'turio-core' ),
				'type' 			=> Controls_Manager::TEXT,
				'placeholder' 	=> esc_html__( 'Enter your title', 'turio-core' ),
				'default' 		=> esc_html__( 'Frequently <span>Asked</span> Question', 'turio-core' ),
				'label_block'   => true,
			]
		);
    
		$this->end_controls_section();

        $this->start_controls_section(
			'section_faq',
			[
				'label' => esc_html__('Faqs', 'turio-core'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'faq_title',
			[
				'label'   => esc_html__('Faq Title', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__('Type faq title','turio-core'),
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'faq_description',
			[
				'label'       => esc_html__('Faq Description', 'turio-core'),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__('Type faq description', 'turio-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'turio_faq_list_item',
			[
				'label' => __('Faq Items', 'turio-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default'	=> [
					[
						'faq_title'          =>'Nulla sed volutpat libero In consequat feugia?',
						'faq_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt molestie turpis nec lacinia vehicula. Quisque eget volutpat purus. Aenean blandit magna maximus landi quam facilisis, tempor porttitor elit hendrerit. Aliquam cursus arcu vel bibendum pulvinar.'
					],
					[
                        'faq_title'          => 'Aenean tempor ac odio ut placerat. Pellentesque ut?',
                        'faq_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt molestie turpis nec lacinia vehicula. Quisque eget volutpat purus. Aenean blandit magna maximus landi quam facilisis, tempor porttitor elit hendrerit. Aliquam cursus arcu vel bibendum pulvinar.'
                    ],
					[
                        'faq_title' => 'Donec ullamcorper dolor vel elit facilisis egestas?',
                        'faq_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt molestie turpis nec lacinia vehicula. Quisque eget volutpat purus. Aenean blandit magna maximus landi quam facilisis, tempor porttitor elit hendrerit. Aliquam cursus arcu vel bibendum pulvinar.'
                    ],
                    [
                        'faq_title' => 'Donec ullamcorper dolor vel elit facilisis egestas?',
                        'faq_description'    => 'Duis rutrum nisl urna. Maecenas vel libero faucibus nisi venenatis hendrerit a id lectus. Suspendissendt molestie turpis nec lacinia vehicula. Quisque eget volutpat purus. Aenean blandit magna maximus landi quam facilisis, tempor porttitor elit hendrerit. Aliquam cursus arcu vel bibendum pulvinar.'
                    ],
				],
				'title_field' => '{{faq_title}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'faq_form_shortcode',
            [
                'label'         => esc_html__('FAQ Form','turio-core'),
                'tab'           => Controls_Manager::TAB,
            ]
        );
        $this->add_control(
            'faq_shortcode',
			[
				'label'   => esc_html__('Form Shortcode', 'turio-core'),
				'type'    => Controls_Manager::TEXT,
				'default' => '',
                'label_block' => true,
			]
        );
        $this->end_controls_section();
        // FAQ Content Section End
        // FAQ Style Section Start
        $this->start_controls_section(
            'faq_style_content_title',
            [
                'label'     => esc_html('Main Title'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'turio_faq_title_style_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2d373c',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-wrapper .faqs h2'   => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_faq_inner_title_style_color',
			[
				'label' 		=> esc_html__( 'Inner Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2e2edd',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-wrapper .faqs h2 span'   => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_faq_title_typography',
				'selector' 		=> '{{WRAPPER}} .faq-wrapper .faqs h2'
			]
		);
        $this->end_controls_section();
        
        $this->start_controls_section(
            'turio_faq_item_title_style',
            [
                'label'         => esc_html__('Item Title'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'turio_faq_item_title_style_color',
			[
				'label' 		=> esc_html__( 'Title Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#FFF',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-wrapper .faq-accordion .accordion-button'   => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_faq_item_title_background_style_color',
			[
				'label' 		=> esc_html__( 'Title Background Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#2d373c',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-wrapper .faq-accordion .accordion-button'   => 'background-color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_faq_item_description_typography',
				'selector' 		=> '{{WRAPPER}} .faq-wrapper .faq-accordion .accordion-button'
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
            'turio_faq_item_description_style',
            [
                'label'         => esc_html__('Item Description'),
                'tab'           => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
			'faq_item_description_style_color',
			[
				'label' 		=> esc_html__( 'Description Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#666666',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-accordion .accordion-body'   => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_faq_item_description_background_style_color',
			[
				'label' 		=> esc_html__( 'Description Background Color', 'turio-core' ),
				'type' 			=> Controls_Manager::COLOR,
                'default' 		=> '#fff',
				'selectors' 	=> [
					'{{WRAPPER}} .faq-wrapper .accordion-body'   => 'background-color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_faq_item_descriptions_typography',
				'selector' 		=> '{{WRAPPER}} .faq-wrapper .accordion-body'
			]
		);
        $this->end_controls_section();
        // FAQ Style Section End

    }
	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
    <div class="faq-wrapper wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="200ms">
        <div class="container">
            <div class="row">
				<div class="<?php if(!empty($settings['faq_shortcode'])) echo 'col-lg-8 col-xl-8 col-md-12 col-sm-12'; else 'col-12';  ?>">
						<div class="faqs mt-30">
							<?php if(!empty($settings['faq_main_title'])) :  ?>
							<h2><?php _e($settings['faq_main_title']) ?></h2>
							<?php endif ?>
							<?php 
							$i = 0;
							if(!empty( $settings['turio_faq_list_item'] ) )  : ?>

							<div class="accordion faq-accordion accordion-flush" id="faq-accordion-example">
							<?php 
								$num = 0;
								foreach($settings['turio_faq_list_item'] as $item) :
								$num++;
								$i++ ?>
                                <div class="accordion-item faq-accordion">
                                  <h2 class="accordion-header" id="faq-headingOne<?php echo $i ?>">
								  	<?php if(!empty($item['faq_title'])) : ?>
										<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq-collapseOne<?php echo $i ?>" aria-expanded="false" aria-controls="faq-collapseOne">
											<?php _e($item['faq_title']) ?>
										</button>
									<?php endif ?>
                                  </h2>
                                  <div id="faq-collapseOne<?php echo $i ?>" class="accordion-collapse collapse <?php echo ($i == 1) ? 'show' : '' ?>" aria-labelledby="faq-headingOne<?php echo $i ?>" data-bs-parent="#faq-accordion-example">
								  	<?php if(!empty($item['faq_description'])) : ?>
										<div class="accordion-body">
											<?php
												_e($item['faq_description'])
											?> 
										</div>
										<?php endif ?>
                                  </div>
                                </div>
								<?php endforeach ?>

                              </div>

							<?php endif ?>
						</div>
					
					</div>
					<?php if(!empty($settings['faq_shortcode'])) : ?>
					<div class="col-lg-4 col-xl-4 col-md-12 col-sm-12">
						<div class="faq-sidebar mt-30">
							<?php echo do_shortcode( $settings['faq_shortcode'] );  ?>
						</div>
					</div>
					<?php endif ?>
				</div>
			</div>
		</div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioFaqWidget() );
