<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Destination_With_Slider_Two extends Widget_Base
{

	public function get_name()
	{
		return 'turio_destination_with_slider';
	}

	public function get_title()
	{
		return esc_html__('TX Destination With Slider Two', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-image-rollover';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_turio_destination_with_slider',
			[
				'label' 		=> esc_html__('Destination', 'turio-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_control(
			'turio_destination_with_slider_pagination_switcher',
			[
				'label' 		=> esc_html__('Show Pagination Bullet', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on' 		=> esc_html__('Enable', 'turio-core'),
				'label_off' 	=> esc_html__('Disable', 'turio-core'),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);
		// Start Package Destination Control
		$this->add_control(
			'turio_destination_with_slider',
			[
				'label' 		=> __('Destination', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => turio_core()->get_terms_names('turio-package-destination', 'id'),
				'default'       => turio_core()->get_all_terms_names('turio-package-destination', 'id'),
			]
		);
		$this->add_control(
			'turio_destination_with_slider_order_by',
			[
				'label'   		=> esc_html__('Order By', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'turio-core'),
					'name'    	=> esc_html__('Name', 'turio-core'),
					'include'  	=> esc_html__('Include', 'turio-core'),
				],
			]
		);
		// Start Turio Package Destination Order
		$this->add_control(
			'turio_destination_with_slider_order',
			[
				'label'   		=> esc_html__('Order', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'turio-core'),
					'desc' 		=> esc_html__('Descending', 'turio-core')
				],
				'default' 		=> 'desc',
			]
		);
		$this->add_control(
			'turio_destination_with_slider_limit',
			[
				'label'   		=> esc_html__('Destination Count', 'turio-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> '8',
			]
		);
		$this->end_controls_section();
		// End Destination Content Control Section
		// Start Box Style Control Section
		$this->start_controls_section(
			'turio_destination_with_slider_box_style',
			[
				'label'   	    => esc_html__('Box Setting', 'turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_destination_with_slider_box_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .destination-card-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();
		// End Box Style Control Section
		// Start Destination Name Style
		$this->start_controls_section(
			'turio_destination_with_slider_name_style',
			[
				'label'  		=> esc_html__('Destination Name', 'turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_destination_with_slider_name_style_color',
			[
				'label'  		=> esc_html__('Color', 'turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title' => 'color : {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_destination_with_slider_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title'
			]
		);

		$this->end_controls_section();
		// Start Destination Place Count Style Two
		$this->start_controls_section(
			'turio_destination_with_slider_place_count_style_two',
			[
				'label'  		=> esc_html__('Place Count', 'turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_destination_with_slider_place_count_style_two_color',
			[
				'label'  		=> esc_html__('Color', 'turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .place-count' => 'color : {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' 		=> esc_html__('Typography', 'turio-core'),
				'name' 			=> 'turio_destination_with_slider_place_style_two_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-two .d-card-content .place-count'
			]
		);
		$this->add_control(
			'turio_destination_with_slider_place_count_border_color',
			[
				'label'  		=> esc_html__('Border Color (Divider)', 'turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title::before' => 'background : {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
		// End Package Destination Place Count Style
		// Start pagination Icon Style
		$this->start_controls_section(
			'turio_destination_with_slider_pagination_style',
			[
				'label'  		=> esc_html__('Pagination Bullet', 'turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
				'condition'		=> [
					'turio_destination_with_slider_pagination_switcher' => 'yes'
				],
			]
		);
		$this->add_control(
			'turio_destination_with_slider_pagination_color',
			[
				'label'     	=> esc_html__('Color', 'turio-core'),
				'type'      	=> Controls_Manager::COLOR,
				'default'   	=> '',
				'selectors' 	=> [
					'{{WRAPPER}} .destination-style-two .testi-pagination span.swiper-pagination-bullet-active::before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .destination-style-two .testi-pagination span.swiper-pagination-bullet-active' => 'border-color: {{VALUE}};',

				],
			]
		);
		$this->end_controls_section();
	}
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		if (is_admin()) {
?>
			<script>
				(function($) {
					var destinationSliderTwo = new Swiper('.destination-slider-two', {
						slidesPerView: 1,
						speed: 1000,
						spaceBetween: 24,

						loop: true,
						roundLengths: true,
						autoplay: {
							delay: 3000
						},
						pagination: {
							el: ".testi-pagination",
							clickable: true
						},
						breakpoints: {
							480: {
								slidesPerView: 2
							},
							768: {
								slidesPerView: 3
							},
							992: {
								slidesPerView: 3
							},
							1200: {
								slidesPerView: 4
							},

						}
					});
				})(jQuery);
			</script>
		<?php
		}

		$destinations = get_terms(array(
			'taxonomy'   	=> 'turio-package-destination',
			'include'    	=> $settings['turio_destination_with_slider'],
			'orderby'    	=> $settings['turio_destination_with_slider_order_by'],
			'order'      	=> $settings['turio_destination_with_slider_order'],
			'number'      	=> $settings['turio_destination_with_slider_limit'],
		));
		?>
		<div class="destination-area destination-style-two">
			<div class="container">
				<div class="swiper destination-slider-two">
					<div class="swiper-wrapper">
						<?php
						$num = 0;
						foreach ($destinations as $destination) :
							$num++;

						?>
							<?php $destination_image = get_term_meta($destination->term_id, 'turio_destination_image_options', true); ?>
							<div class="swiper-slide">
								<div class="destination-card-style-two wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num + 1) * 2 ?>00ms">
									<div class="d-card-thumb">
										<img src="<?php echo $destination_image['destination_image']['url'] ?>" alt="<?php echo $destination_image['destination_image']['alt']; ?>">
									</div>
									<div class="d-card-content">

										<?php if (!empty($destination->name)) : ?>
											<h4 class="destination-title"><a href="<?php echo esc_url(get_term_link($destination)) ?>"><?php echo $destination->name ?></a></h4>
										<?php endif; ?>

										<?php if (!empty($destination->count)) : ?>
											<div class="place-count">
												<span><?php echo $destination->count; ?></span> <?php esc_html_e('Place', 'turio-core') ?>
											</div>
										<?php endif; ?>

									</div>
								</div>
							</div>
						<?php endforeach ?>
					</div>
					<?php if (!empty($settings['turio_destination_with_slider_pagination_switcher']) && $settings['turio_destination_with_slider_pagination_switcher'] == 'yes') : ?>
						<div class="testi-pagination text-center"></div>
					<?php endif ?>
				</div>
			</div>
		</div>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Destination_With_Slider_Two());
