<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class TurioDestinationGrid extends Widget_Base {

	public function get_name() {
		return 'turio_destination_grid';
	}

	public function get_title() {
		return esc_html__( 'TX Destination Grid', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-image-rollover';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
        // Start Package Header Section Control
		$this->start_controls_section(
			'section_destination_grid',
			[
				'label' 		=> esc_html__('Destination','turio-core'),
				'tab'  			=> Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_control(
			'turio_destination_grid_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
					'column_six' => esc_html__('6', 'turio-core'),
				],
				'default' => 'column_four',
			]
		);
        // Start Package Destination Control
        $this->add_control(
			'turio_package_destination_grid',
			[
				'label' 		=> __('Destination', 'turio-core'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple'      => true,
				'options'       => turio_core()->get_terms_names('turio-package-destination', 'id'),
				'default'       => turio_core()->get_all_terms_names('turio-package-destination','id'),
			]
		);
		$this->add_control(
			'turio_package_destination_grid_order_by',
			[
				'label'   		=> esc_html__('Order By', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'default' 		=> 'term_id',
				'options' 		=> [
					'term_id'   => esc_html__('Term ID', 'turio-core'),
					'name'    	=> esc_html__('Name', 'turio-core'),
					'include'  	=> esc_html__('Include', 'turio-core'),
				],
			]
		);
		// Start Turio Package Destination Order
		$this->add_control(
			'turio_package_destination_grid_order',
			[
				'label'   		=> esc_html__('Order', 'turio-core'),
				'type'    		=> Controls_Manager::SELECT,
				'options'		=> [
					'asc'  		=> esc_html__('Ascending', 'turio-core'),
					'desc' 		=> esc_html__('Descending', 'turio-core')
				],
				'default' 		=> 'desc',
			]
		);
		$this->add_control(
			'turio_package_destination_grid_limit',
			[
				'label'   		=> esc_html__('Destination Count', 'turio-core'),
				'type'    		=> Controls_Manager::NUMBER,
				'default' 		=> '8',
			]
		);
        $this->end_controls_section();
        // End Destination Content Control Section
		// Start General Style Control Section
		$this->start_controls_section(
			'turio_package_destination_grid_style',
			[
				'label'   	    => esc_html__('Box Setting','turio-core'),
				'tab'   		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'turio_package_destination_grid_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .destination-wrapper .destination-card-style-two' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_package_destination_grid_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .destination-wrapper .destination-card-style-two',
			]
		);
		$this->end_controls_section();
		// End General Style Control Section
		// Start Destination Style
		$this->start_controls_section(
			'turio_package_destination_grid_name_style',
			[
				'label'  		=> esc_html__('Destination Name','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_destination_grid_name_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_control(
			'turio_package_destination_grid_name_style_border_color',
			[
				'label'  		=> esc_html__('Hover Color (Border)','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title::before' => 'background : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_package_destination_grid_name_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-two .d-card-content .destination-title'
			]
		);

		$this->end_controls_section();

		// Start Destination Place Style
		$this->start_controls_section(
			'turio_package_destination_grid_place_count_style',
			[
				'label'  		=> esc_html__('Place Count','turio-core'),
				'tab'    		=> Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'turio_package_destination_grid_place_count_style_color',
			[
				'label'  		=> esc_html__('Color','turio-core'),
				'type'   		=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .destination-card-style-two .d-card-content .place-count' => 'color : {{VALUE}}'
				],	
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
                'label' 		=> esc_html__('Typography','turio-core'),
				'name' 			=> 'turio_package_destination_grid_place_count_style_typography',
				'selector' 		=> '{{WRAPPER}} .destination-card-style-two .d-card-content .place-count'
			]
		);

		$this->end_controls_section();
		// End Package Destination Description Style
    }
	protected function render() {
		$settings = $this->get_settings_for_display(); 

		$destinations = get_terms( array(
                'taxonomy'   	=> 'turio-package-destination',
                'include'    	=> $settings['turio_package_destination_grid'],
                'orderby'    	=> $settings['turio_package_destination_grid_order_by'],
                'order'      	=> $settings['turio_package_destination_grid_order'],
                'number'      	=> $settings['turio_package_destination_grid_limit'],
            ) );
		?>
    <div class="destination-wrapper">
        <div class="container">
            <div class="row g-3">
				
                	<?php
						$num = 0;
						foreach($destinations as $destination) :
						$num++;		
					?>
				
                    <?php $destination_image = get_term_meta( $destination->term_id, 'turio_destination_image_options', true ); ?>
                    
					<?php if( $settings['turio_destination_grid_column_section'] == 'column_two' ) : ?>
						<div class="col-xl-6 col-lg-6 col-md-4 col-sm-10">
					<?php elseif ($settings['turio_destination_grid_column_section'] == 'column_three') : ?>
						<div class="col-xl-4 col-lg-4 col-md-4 col-sm-10">
					<?php elseif ($settings['turio_destination_grid_column_section'] == 'column_four') : ?>
						<div class="col-xl-3 col-lg-3 col-md-4 col-sm-10">
					<?php elseif ($settings['turio_destination_grid_column_section'] == 'column_six') : ?>
						<div class="col-xl-2 col-lg-2 col-md-4 col-sm-10">
					<?php endif ?>
                        <div class="destination-card-style-two wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
                            <?php if (!empty($destination_image)): ?>
                                <div class="d-card-thumb">
                                    <a href="<?php echo esc_url( get_term_link( $destination ) ) ?>">
                                        <img src="<?php echo $destination_image['destination_image']['url'] ?>" alt="<?php echo $destination_image['destination_image']['alt']; ?>">
                                    </a>
                                </div>
                            <?php endif ?>
                            <div class="d-card-content">
                                <?php if(!empty($destination->name)) : ?>
                                    <h4 class="destination-title">
                                        <a href="<?php echo esc_url( get_term_link( $destination ) ) ?>"><?php echo $destination->name ?></a>
                                    </h4>
                                <?php endif ?>
                                <?php if (!empty($destination->count)): ?>
                                    <div class="place-count">
                                        <span><?php echo $destination->count; ?></span> <?php esc_html_e('Place','turio-core') ?>
                                    </div>
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        </div>
    </div>
		<?php
    }
}

Plugin::instance()->widgets_manager->register( new TurioDestinationGrid() );
