<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

use Elementor\Core\Schemes;

class Turio_Card_Carousel_Widget extends Widget_Base {

	public function get_name() {
		return 'turio_card_carousel';
	}

	public function get_title() {
		return esc_html__( 'TX Card Carousel', 'turio-core' );
	}

	public function get_icon() {
		return 'eicon-carousel';
	}

	public function get_categories() {
		return [ 'turio_widgets' ];
	}

	protected function register_controls() {
		
		$this->start_controls_section(
			'section_general',
			[
				'label' => esc_html__( 'General', 'turio-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT
			]
		);
		
        $repeater = new Repeater();

		$repeater->add_control(
			'turio_card_carousel_author_name',
			[
				'label'       => esc_html__( 'Social', 'turio-core' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'John Due', 'turio-core' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'turio_card_carousel_author_image',
			[
				'label'   => esc_html__( 'Choose Image', 'turio-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		
		$repeater->add_control(
			'turio_card_carousel_icon',
			[
				'label' => esc_html__( 'Icon', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'bx bx-link',
					'library' => 'solid',
				],
			]
		);

		$repeater->add_control(
			'turio_card_carousel_link',
			[
				'label' => __( 'Button Link', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'turio-core' ),
				'show_external' => true,
				'default' => [
					'url' => 'https://your-link.com',
					'is_external' => false,
					'nofollow' => true,
				],
			]
		);

	
		$this->add_control(
			'turio_card_carousel_list',
			[
				'label'   => esc_html__( 'Social Activity List', 'turio-core' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
						'turio_card_carousel_author_name'   => esc_html__( 'Item 1', 'turio-core' ),
						'turio_card_carousel_author_name_default_active' => 'yes'
					],
					[
						'turio_card_carousel_author_name'   => esc_html__( 'Item 2', 'turio-core' ),
					],
					[
						'turio_card_carousel_author_name'   => esc_html__( 'Item 3', 'turio-core' ),
					],
				],
				'title_field' => '{{{ turio_card_carousel_author_name }}}',
			]
		);
		

		$this->end_controls_section();


		//Style Section
        $this->start_controls_section(
            'turio_heading_icon_style',
            [
                'label' => esc_html__('Icon', 'turio-core'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'turio_heading_card_overlay_color',
            [
                'label'     => esc_html__('Overlay Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-card .social-overlay' => 'background: linear-gradient( 180deg, #2d373cb3 0%, {{VALUE}} 100%);',
                ],
            ]
        );

        $this->add_control(
            'turio_heading_icon_color',
            [
                'label'     => esc_html__('Color', 'turio-core'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-card .social-overlay svg path' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .social-card .social-overlay i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'turio_heading_icon_size',
			[
				'label' => esc_html__( 'Size', 'turio-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					]
				],
				'default' => [
					'unit' => 'px',
					'size' => 14,
				],
				'selectors' => [
					'{{WRAPPER}} .social-card .social-overlay svg' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .social-card .social-overlay i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();


	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();


	if ( is_admin() ) {
		?>
		<script>
		(function ($) {

			var socialSlider = new Swiper('.social-activity-slider', {
			slidesPerView: 2,
			speed: 1000,
			spaceBetween: 24,
			centeredSlides : true,
			loop: true,
			roundLengths: true,
			autoplay: {
			delay: 15000
			},
			pagination: {
			el: ".testi-pagination",
			clickable: true
			},
			breakpoints: {
			480:{
				slidesPerView: 3
			},
			768:{
				slidesPerView: 3
			},
			992:{ 
				slidesPerView: 4
			},
			1200:{
				slidesPerView: 5
			},
			
			}
		});	

    		})(jQuery);
    	</script>
		<?php
		}
		?>
		<div class="social-activity-area">
        <div class="container-fluid p-0">
            <div class="swiper social-activity-slider">
                <div class="swiper-wrapper">
				<?php 
						if(!empty($settings['turio_card_carousel_list'])) :
							$num = 0;
							foreach ( $settings['turio_card_carousel_list'] as $item ) :
							$num++;
								$url = $item['turio_card_carousel_link']['url'];
								$target = $item['turio_card_carousel_link']['is_external'] ? ' target="_blank"' : '';
								$nofollow = $item['turio_card_carousel_link']['nofollow'] ? ' rel="nofollow"' : '';
						?>
                    <div class="swiper-slide">
                        <div class="social-card  wow animate fadeInUp" data-wow-duration="1500ms" data-wow-delay="<?php echo ($num+1)*2 ?>00ms">
                            <div class="social-thumb">
							<?php 
								if(!empty($item['turio_card_carousel_author_image'])) :
									?>
									<?php 
										$img_alt = empty($item['turio_card_carousel_author_name']) ? '' : $item['turio_card_carousel_author_name']; 
									?>
									<img class="img-fluid" src="<?php echo esc_url( $item['turio_card_carousel_author_image']['url'] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
									<?php 
								endif;
                                ?>
                            </div>

                            <a class="social-overlay" href="<?php echo esc_url( $url ); ?>" <?php echo $target.' '.$nofollow; ?>>
							<?php \Elementor\Icons_Manager::render_icon( $item['turio_card_carousel_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        </div>
                    </div>
					<?php 
							endforeach;
						endif;
					?>

               </div>
            </div>
        </div>
    </div>
        
		<?php
	}
}

Plugin::instance()->widgets_manager->register( new Turio_Card_Carousel_Widget() );
