<?php

namespace Elementor;

if (!defined('ABSPATH')) {
	exit;
} // Exit if accessed directly

use Elementor\core\Schemes;

class Turio_Blog_Three extends Widget_Base
{

	public function get_name()
	{
		return 'turio_blog_three';
	}

	public function get_title()
	{
		return esc_html__('TX Blog Style Three', 'turio-core');
	}

	public function get_icon()
	{
		return 'eicon-posts-grid';
	}

	public function get_categories()
	{
		return ['turio_widgets'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'post_settings',
			[
				'label' => esc_html__('General', 'turio-core')
			]
		);
		$this->add_control(
			'turio_tour_blog_three_column_section',
			[
				'label'   => esc_html__('Select Column', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'column_two'  => esc_html__('2', 'turio-core'),
					'column_three' => esc_html__('3', 'turio-core'),
					'column_four' => esc_html__('4', 'turio-core'),
				],
				'default' => 'column_three',
			]
		);
		$this->add_control(
			'turio_blog_date_switcher',
			[
				'label' => esc_html__('Show Date', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_blog_one_icon_switcher',
			[
				'label' => esc_html__('Show Icon', 'turio-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Enable', 'turio-core'),
				'label_off' => esc_html__('Disable', 'turio-core'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'turio_blog_posts_per_page',
			[
				'label'       => esc_html__('Posts Per Page', 'turio-core'),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 3,
				'label_block' => true,
			]
		);
		$this->add_control(
			'turio_blog_orderby',
			[
				'label'   => esc_html__('Order By', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ID',
				'options' => [
					'ID'         => esc_html__('Post Id', 'turio-core'),
					'author'     => esc_html__('Post Author', 'turio-core'),
					'title'      => esc_html__('Title', 'turio-core'),
					'post_date'  => esc_html__('Date', 'turio-core'),
					'rand'       => esc_html__('Random', 'turio-core'),
					'menu_order' => esc_html__('Menu Order', 'turio-core'),
				],
			]
		);
		$this->add_control(
			'turio_blog_order',
			[
				'label'   => esc_html__('Order', 'turio-core'),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__('Ascending', 'turio-core'),
					'desc' => esc_html__('Descending', 'turio-core')
				],
				'default' => 'desc',
			]
		);

		$this->end_controls_section();

        // Start Blog Three Box Deisgn Style
        $this->start_controls_section(
            'turio_blog_three_box_design_style',
            [
                'label'   		=> esc_html__('Box Setting','turio-core'),
                'tab'      		=> Controls_Manager::TAB_STYLE,
            ]
        );
		$this->add_control(
			'turio_blog_three_box_design_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'turio_blog_three_box_design_border_radius_style',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .blog-card-beta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' 			=> 'turio_blog_three_box_design_box_shadow_style',
				'label' 		=> esc_html__( 'Box Shadow', 'turio-core' ),
				'selector' 		=> '{{WRAPPER}} .blog-card-beta',
			]
		);
        
        $this->end_controls_section();
        // End Blog Three Box Design Style

		/// Date Style
		$this->start_controls_section(
			'turio_blog_date_style',
			[
				'label' => esc_html__('Date', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_date_switcher' => 'yes'
				]

			]
		);
		$this->add_control(
			'turio_blog_date_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_date_typography',
				'selector' => '{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a',

			]
		);
		$this->add_control(
			'turio_blog_date_bg_color',
			[
				'label'     => esc_html__('Background Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a' => 'background: {{VALUE}};',
				],

			]
		);
        $this->add_control(
			'turio_blog_date_color_hover',
			[
				'label'     => esc_html__('Hover Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta:hover .blog-thumb .blog-lavel a' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'turio_blog_date_hover_background',
			[
				'label'     => esc_html__('Hover Background', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta:hover .blog-thumb .blog-lavel a' => 'background: {{VALUE}};',
				],

			]
		);
		$this->add_responsive_control(
			'turio_blog_date_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
            'turio_blog_date_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
			'turio_blog_date_border_radius',
			[
				'label'      	=> __('Border Radius', 'turio-core'),
				'type'       	=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> ['px', '%'],
				'selectors'  	=> [
					'{{WRAPPER}} .blog-card-beta .blog-thumb .blog-lavel a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->end_controls_section();

		/// Blog Title Style
		$this->start_controls_section(
			'turio_blog_title_style',
			[
				'label' => esc_html__('Title', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_title_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-title' => 'color: {{VALUE}}',
				],
				'default' => '#262339',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_title_typography',
				'selector' => '{{WRAPPER}} .blog-card-beta .blog-content .blog-title',

			]
		);
		$this->add_control(
			'turio_blog_title_hover_color',
			[
				'label'     => esc_html__('Hover Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-title:hover a' => 'color: {{VALUE}}',
				],
				'default' => '#54a15d',
			]
		);
		$this->add_responsive_control(
			'turio_blog_title_padding',
			[
				'label'      => __('Padding', 'turio-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors'  => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				]
			]
		);
		$this->add_responsive_control(
            'turio_blog_title_margin',
            [
                'label' => esc_html__( 'Margin', 'turio-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-card-beta .blog-content .blog-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		$this->end_controls_section();
		/// Icon Style
		$this->start_controls_section(
			'turio_blog_icon_style',
			[
				'label' => esc_html__('Icon (Author & Comment)', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'turio_blog_one_icon_switcher' => 'yes'
				]

			]
		);

		$this->add_control(
			'turio_blog_icon_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-body-top a i' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
		/// Author Name Style
		$this->start_controls_section(
			'turio_blog_author_name_style',
			[
				'label' => esc_html__('Author Name', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_author_name_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-body-top a.blog-writer' => 'color: {{VALUE}}',
				],
				'default' => '#696969',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_author_name_typography',
				'selector' => '{{WRAPPER}} .blog-card-beta .blog-content .blog-body-top a.blog-writer',

			]
		);

		$this->end_controls_section();

		/// Comment Style
		$this->start_controls_section(
			'turio_blog_comment_style',
			[
				'label' => esc_html__('Comment', 'turio-core'),
				'tab'   => Controls_Manager::TAB_STYLE,

			]
		);
		$this->add_control(
			'turio_blog_comment_color',
			[
				'label'     => esc_html__('Color', 'turio-core'),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-card-beta .blog-content .blog-body-top a.blog-comments' => 'color: {{VALUE}}',
				],
				'default' => '#696969',
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__('Typography', 'turio-core'),
				'name'     => 'turio_blog_comment_typography',
				'selector' => '{{WRAPPER}} .blog-card-beta .blog-content .blog-body-top a.blog-comments',

			]
		);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();

		$query = new \WP_Query(
			array(
				'post_type'      => 'post',
				'posts_per_page' => $settings['turio_blog_posts_per_page'],
				'orderby'        => $settings['turio_blog_orderby'],
				'order'          => $settings['turio_blog_order'],
				'paged' 		 => (get_query_var('paged')) ? get_query_var('paged') : 1,
				'offset'         => 0,
				'post_status'    => 'publish'
			)
		);
?>

        <div class="blog-area blog-style-two">
			<div class="container">
				<div class="row">
					<?php

					if (!empty($query->have_posts())) :
						$num = 0;
						while ($query->have_posts()) :
						$num++;
							$query->the_post();
						?>
						<?php if( $settings['turio_tour_blog_three_column_section'] == 'column_two' ) : ?>
							<div class="col-xl-6 col-lg-6 col-md-6 col-sm-10">
						<?php elseif ($settings['turio_tour_blog_three_column_section'] == 'column_three') : ?>
							<div class="col-xl-4 col-lg-4 col-md-6 col-sm-10">
						<?php elseif ($settings['turio_tour_blog_three_column_section'] == 'column_four') : ?>
							<div class="col-xl-3 col-lg-3 col-md-6 col-sm-10">
						<?php endif ?>
							<div class="blog-card-beta">
								<div class="blog-thumb">
									<?php if (has_post_thumbnail()) { ?>
										<a href="<?php the_permalink(); ?>">
											<?php the_post_thumbnail(); ?>
										</a>
									<?php
									}
									if ('yes' == $settings['turio_blog_date_switcher']) {
									?>
										<div class="blog-lavel">
											<a href="<?php echo get_day_link(get_post_time('Y'), get_post_time('m'), get_post_time('j')); ?>"><?php echo get_the_date(); ?></a>
										</div>
									<?php
									}
									?>
								</div>
								<div class="blog-content">
									<div class="blog-body-top">
										<a href="#" class="blog-writer"><?php if ('yes' == $settings['turio_blog_one_icon_switcher']) { echo '<i class="bi bi-person-circle"></i> ';} ?> <?php _e('By ', 'turio-core'); ?><?php echo get_the_author(); ?> </a>
										<a href="#" class="blog-comments"><?php if ('yes' == $settings['turio_blog_one_icon_switcher']) { echo '<i class="bi bi-chat-dots-fill"></i>';} ?> <?php echo wp_kses_post('(' . get_comments_number() . ')' . ' ' . 'Comment'); ?></a>
									</div>
									<h4 class="blog-title">
										<a href="<?php the_permalink(); ?>">
											<?php echo esc_html__(substr( get_the_title(), '0', '55'), 'turio-core' ); ?>
										</a>
									</h4>
								</div>
							</div>
						</div>
					<?php
						endwhile;

						global $wp_query;
						$links = paginate_links( array(
							'current'  => max( 1, get_query_var( 'paged' ) ),
							'total'    => $wp_query->max_num_pages,
							'type'     => 'list',
							'mid_size' => apply_filters( "turio_pagination_mid_size", 3 ),
							'prev_text'    => '<i class="bi bi-chevron-double-left"></i>',
							'next_text'    => '<i class="bi bi-chevron-double-right"></i>',
						) );
						$links = str_replace( "<ul class='page-numbers'>", "<ul class='pagination pagination-style-one justify-content-center pt-50'>", $links );
						$links = str_replace( "<li>", "<li class='page-item'>", $links );
						$links = str_replace( "page-numbers", "page-link", $links );
						$links = str_replace( "&laquo; Previous</a>", '&laquo;</a>', $links );
						$links = str_replace( "Next &raquo;</a>", "&raquo;</a>", $links );
						$links = str_replace( "next aria-label='Next'", "page-link", $links );
						$links = str_replace( "prev aria-hidden='true'", "sr-only page-link", $links );
						$links = str_replace( "<li class='page-item'><span", " <li class='page-item active'><a", $links );
						$links = str_replace( 'span', 'a', $links );
						
						echo wp_kses_post( $links );
						echo "Hello World";
						// wp_reset_query();
					endif;

					?>
				</div>
			</div>
        </div>

<?php
	}
}

Plugin::instance()->widgets_manager->register(new Turio_Blog_Three());
